/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.slack.util;

import com.slack.api.methods.SlackApiException;
import com.slack.api.model.Message;
import java.util.Objects;
import org.apache.nifi.processors.slack.consume.PartialThreadException;
import org.apache.nifi.util.StringUtils;

public class SlackResponseUtil {
    public static String getErrorMessage(String error, String needed, String provided, String warning) {
        String mainMessage = Objects.requireNonNullElse(error, warning);
        if (needed != null && provided != null) {
            return mainMessage + ": Permission needed: " + needed + "; Permission granted to this bot: " + provided;
        }
        return mainMessage;
    }

    private static Throwable getCauseOfPartialThreadException(Throwable t) {
        if (t instanceof PartialThreadException) {
            PartialThreadException pte = (PartialThreadException)t;
            Throwable cause = pte.getCause();
            return cause == null ? t : cause;
        }
        return t;
    }

    public static boolean isRateLimited(Throwable throwable) {
        Throwable cause = SlackResponseUtil.getCauseOfPartialThreadException(throwable);
        return cause instanceof SlackApiException && 429 == ((SlackApiException)cause).getResponse().code();
    }

    public static int getRetryAfterSeconds(Throwable throwable) {
        Throwable cause = SlackResponseUtil.getCauseOfPartialThreadException(throwable);
        if (!(cause instanceof SlackApiException)) {
            return 1;
        }
        SlackApiException slackApiException = (SlackApiException)cause;
        return Integer.parseInt(slackApiException.getResponse().header("Retry-After", "10"));
    }

    public static boolean hasReplies(Message message) {
        String threadTs = message.getThreadTs();
        return !StringUtils.isEmpty((String)threadTs);
    }
}

