/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellRunner {
    private static final Logger logger = LoggerFactory.getLogger(ShellRunner.class);
    static String SHELL = "sh";
    static String OPTS = "-c";
    static Integer TIMEOUT = 60;

    public static List<String> runShell(String command) throws IOException {
        return ShellRunner.runShell(command, "<unknown>");
    }

    public static List<String> runShell(String command, String description) throws IOException {
        boolean completed;
        ProcessBuilder builder = new ProcessBuilder(SHELL, OPTS, command);
        List<String> builderCommand = builder.command();
        logger.debug("Run Command '" + description + "': " + builderCommand);
        Process proc = builder.start();
        try {
            completed = proc.waitFor(TIMEOUT.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException irexc) {
            throw new IOException(irexc.getMessage(), irexc.getCause());
        }
        if (!completed) {
            throw new IllegalStateException("Shell command '" + command + "' did not complete during the allotted time period");
        }
        if (proc.exitValue() != 0) {
            try (InputStreamReader stderr = new InputStreamReader(proc.getErrorStream());
                 BufferedReader reader = new BufferedReader(stderr);){
                String line;
                while ((line = reader.readLine()) != null) {
                    logger.warn(line.trim());
                }
            }
            throw new IOException("Command exit non-zero: " + proc.exitValue());
        }
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStreamReader stdin = new InputStreamReader(proc.getInputStream());
             BufferedReader reader = new BufferedReader(stdin);){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line.trim());
            }
        }
        return lines;
    }
}

