/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.repository.block.aes;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.nifi.security.kms.CryptoUtils;
import org.apache.nifi.security.kms.EncryptionException;
import org.apache.nifi.security.repository.AbstractAESEncryptor;
import org.apache.nifi.security.repository.RepositoryEncryptorUtils;
import org.apache.nifi.security.repository.RepositoryObjectEncryptionMetadata;
import org.apache.nifi.security.repository.block.BlockEncryptionMetadata;
import org.apache.nifi.security.repository.block.RepositoryObjectBlockEncryptor;
import org.apache.nifi.security.util.EncryptionMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryObjectAESGCMEncryptor
extends AbstractAESEncryptor
implements RepositoryObjectBlockEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryObjectAESGCMEncryptor.class);
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final String VERSION = "v1";
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("v1");
    private static final int MIN_METADATA_LENGTH = 22;
    private static final int METADATA_DEFAULT_LENGTH = (20 + "AES/GCM/NoPadding".length() + 16 + "v1".length()) * 2;
    private static final byte[] SENTINEL = new byte[]{1};

    @Override
    public byte[] encrypt(byte[] plainRecord, String recordId, String keyId) throws EncryptionException {
        if (plainRecord == null || CryptoUtils.isEmpty(keyId)) {
            throw new EncryptionException("The repository object and key ID cannot be missing");
        }
        if (this.keyProvider == null || !this.keyProvider.keyExists(keyId)) {
            throw new EncryptionException("The requested key ID is not available");
        }
        byte[] ivBytes = new byte[16];
        new SecureRandom().nextBytes(ivBytes);
        try {
            logger.debug("Encrypting repository object " + recordId + " with key ID " + keyId);
            Cipher cipher = RepositoryEncryptorUtils.initCipher(this.aesKeyedCipherProvider, EncryptionMethod.AES_GCM, 1, this.keyProvider.getKey(keyId), ivBytes);
            ivBytes = cipher.getIV();
            byte[] cipherBytes = cipher.doFinal(plainRecord);
            BlockEncryptionMetadata metadata = new BlockEncryptionMetadata(keyId, ALGORITHM, ivBytes, VERSION, cipherBytes.length);
            byte[] serializedEncryptionMetadata = RepositoryEncryptorUtils.serializeEncryptionMetadata(metadata);
            logger.debug("Generated encryption metadata ({} bytes) for repository object {}", (Object)serializedEncryptionMetadata.length, (Object)recordId);
            logger.debug("Encrypted repository object " + recordId + " with key ID " + keyId);
            return CryptoUtils.concatByteArrays(serializedEncryptionMetadata, cipherBytes);
        }
        catch (IOException | KeyManagementException | BadPaddingException | IllegalBlockSizeException | EncryptionException e) {
            String msg = "Encountered an exception encrypting repository object " + recordId;
            logger.error(msg, (Throwable)e);
            throw new EncryptionException(msg, e);
        }
    }

    @Override
    public byte[] decrypt(byte[] encryptedRecord, String recordId) throws EncryptionException {
        RepositoryObjectEncryptionMetadata metadata = RepositoryObjectAESGCMEncryptor.prepareObjectForDecryption(encryptedRecord, recordId, "repository object", SUPPORTED_VERSIONS);
        if (this.keyProvider == null || !this.keyProvider.keyExists(metadata.keyId) || CryptoUtils.isEmpty(metadata.keyId)) {
            throw new EncryptionException("The requested key ID " + metadata.keyId + " is not available");
        }
        try {
            logger.debug("Decrypting repository object " + recordId + " with key ID " + metadata.keyId);
            EncryptionMethod method = EncryptionMethod.forAlgorithm(metadata.algorithm);
            Cipher cipher = RepositoryEncryptorUtils.initCipher(this.aesKeyedCipherProvider, method, 2, this.keyProvider.getKey(metadata.keyId), metadata.ivBytes);
            byte[] cipherBytes = this.extractCipherBytes(encryptedRecord, metadata);
            byte[] plainBytes = cipher.doFinal(cipherBytes);
            logger.debug("Decrypted repository object " + recordId + " with key ID " + metadata.keyId);
            return plainBytes;
        }
        catch (KeyManagementException | BadPaddingException | IllegalBlockSizeException | EncryptionException e) {
            String msg = "Encountered an exception decrypting repository object " + recordId;
            logger.error(msg, (Throwable)e);
            throw new EncryptionException(msg, e);
        }
    }

    @Override
    public String getNextKeyId() throws KeyManagementException {
        List<String> availableKeyIds;
        if (this.keyProvider != null && !(availableKeyIds = this.keyProvider.getAvailableKeyIds()).isEmpty()) {
            return availableKeyIds.get(0);
        }
        throw new KeyManagementException("No available key IDs");
    }

    private byte[] extractCipherBytes(byte[] encryptedRecord, RepositoryObjectEncryptionMetadata metadata) {
        return Arrays.copyOfRange(encryptedRecord, encryptedRecord.length - metadata.cipherByteLength, encryptedRecord.length);
    }

    public String toString() {
        return "Repository Object Block Encryptor using AES G/CM with Key Provider: " + this.keyProvider.toString();
    }
}

