/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.util.Tuple;

public final class SslContextFactory {
    public static SSLContext createSslContext(String keystore, char[] keystorePasswd, String keystoreType, String truststore, char[] truststorePasswd, String truststoreType, ClientAuth clientAuth, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        return SslContextFactory.createSslContext(keystore, keystorePasswd, keystorePasswd, keystoreType, truststore, truststorePasswd, truststoreType, clientAuth, protocol);
    }

    public static SSLContext createSslContext(String keystore, char[] keystorePasswd, char[] keyPasswd, String keystoreType, String truststore, char[] truststorePasswd, String truststoreType, ClientAuth clientAuth, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        return (SSLContext)SslContextFactory.createSslContextWithTrustManagers(keystore, keystorePasswd, keyPasswd, keystoreType, truststore, truststorePasswd, truststoreType, clientAuth, protocol).getKey();
    }

    public static Tuple<SSLContext, TrustManager[]> createSslContextWithTrustManagers(String keystore, char[] keystorePasswd, char[] keyPasswd, String keystoreType, String truststore, char[] truststorePasswd, String truststoreType, ClientAuth clientAuth, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStoreUtils.getKeyStore(keystoreType);
        try (FileInputStream keyStoreStream = new FileInputStream(keystore);){
            keyStore.load(keyStoreStream, keystorePasswd);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (keyPasswd == null) {
            keyManagerFactory.init(keyStore, keystorePasswd);
        } else {
            keyManagerFactory.init(keyStore, keyPasswd);
        }
        KeyStore trustStore = KeyStoreUtils.getTrustStore(truststoreType);
        try (FileInputStream trustStoreStream = new FileInputStream(truststore);){
            trustStore.load(trustStoreStream, truststorePasswd);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance(protocol);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        if (ClientAuth.REQUIRED == clientAuth) {
            sslContext.getDefaultSSLParameters().setNeedClientAuth(true);
        } else if (ClientAuth.WANT == clientAuth) {
            sslContext.getDefaultSSLParameters().setWantClientAuth(true);
        } else {
            sslContext.getDefaultSSLParameters().setWantClientAuth(false);
        }
        return new Tuple((Object)sslContext, (Object)trustManagerFactory.getTrustManagers());
    }

    public static SSLContext createSslContext(String keystore, char[] keystorePasswd, String keystoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        return SslContextFactory.createSslContext(keystore, keystorePasswd, keystorePasswd, keystoreType, protocol);
    }

    public static SSLContext createSslContext(String keystore, char[] keystorePasswd, char[] keyPasswd, String keystoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        return (SSLContext)SslContextFactory.createSslContextWithTrustManagers(keystore, keystorePasswd, keyPasswd, keystoreType, protocol).getKey();
    }

    public static Tuple<SSLContext, TrustManager[]> createSslContextWithTrustManagers(String keystore, char[] keystorePasswd, char[] keyPasswd, String keystoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStoreUtils.getKeyStore(keystoreType);
        try (FileInputStream keyStoreStream = new FileInputStream(keystore);){
            keyStore.load(keyStoreStream, keystorePasswd);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (keyPasswd == null) {
            keyManagerFactory.init(keyStore, keystorePasswd);
        } else {
            keyManagerFactory.init(keyStore, keyPasswd);
        }
        SSLContext ctx = SSLContext.getInstance(protocol);
        TrustManager[] trustManagers = new TrustManager[]{};
        ctx.init(keyManagerFactory.getKeyManagers(), trustManagers, new SecureRandom());
        return new Tuple((Object)ctx, (Object)trustManagers);
    }

    public static SSLContext createTrustSslContext(String truststore, char[] truststorePasswd, String truststoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        return (SSLContext)SslContextFactory.createTrustSslContextWithTrustManagers(truststore, truststorePasswd, truststoreType, protocol).getKey();
    }

    public static Tuple<SSLContext, TrustManager[]> createTrustSslContextWithTrustManagers(String truststore, char[] truststorePasswd, String truststoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore trustStore = KeyStoreUtils.getTrustStore(truststoreType);
        try (FileInputStream trustStoreStream = new FileInputStream(truststore);){
            trustStore.load(trustStoreStream, truststorePasswd);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        SSLContext ctx = SSLContext.getInstance(protocol);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        ctx.init(new KeyManager[0], trustManagers, new SecureRandom());
        return new Tuple((Object)ctx, (Object)trustManagers);
    }

    public static Tuple<SSLContext, TrustManager[]> createTrustSslContextWithTrustManagers(String keystore, char[] keystorePasswd, char[] keyPasswd, String keystoreType, String truststore, char[] truststorePasswd, String truststoreType, ClientAuth clientAuth, String protocol) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        Tuple<SSLContext, TrustManager[]> sslContextWithTrustManagers = keystore == null ? SslContextFactory.createTrustSslContextWithTrustManagers(truststore, truststorePasswd, truststoreType, protocol) : (truststore == null ? SslContextFactory.createSslContextWithTrustManagers(keystore, keystorePasswd, keyPasswd, keystoreType, protocol) : SslContextFactory.createSslContextWithTrustManagers(keystore, keystorePasswd, keyPasswd, keystoreType, truststore, truststorePasswd, truststoreType, clientAuth, protocol));
        return new Tuple(sslContextWithTrustManagers.getKey(), sslContextWithTrustManagers.getValue());
    }

    public static enum ClientAuth {
        WANT,
        REQUIRED,
        NONE;

    }
}

