/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreUtils {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreUtils.class);
    public static final String SUN_PROVIDER_NAME = "SUN";

    public static String getKeyStoreProvider(String keyStoreType) {
        if (KeystoreType.PKCS12.toString().equalsIgnoreCase(keyStoreType)) {
            return "BC";
        }
        if (KeystoreType.JKS.toString().equalsIgnoreCase(keyStoreType)) {
            return SUN_PROVIDER_NAME;
        }
        return null;
    }

    public static KeyStore getKeyStore(String keyStoreType) throws KeyStoreException {
        String keyStoreProvider = KeyStoreUtils.getKeyStoreProvider(keyStoreType);
        if (StringUtils.isNotEmpty((CharSequence)keyStoreProvider)) {
            try {
                return KeyStore.getInstance(keyStoreType, keyStoreProvider);
            }
            catch (Exception e) {
                logger.error("Unable to load " + keyStoreProvider + " " + keyStoreType + " keystore.  This may cause issues getting trusted CA certificates as well as Certificate Chains for use in TLS.", (Throwable)e);
            }
        }
        return KeyStore.getInstance(keyStoreType);
    }

    public static KeyStore getTrustStore(String trustStoreType) throws KeyStoreException {
        if (KeystoreType.PKCS12.toString().equalsIgnoreCase(trustStoreType)) {
            logger.warn(trustStoreType + " truststores are deprecated.  " + KeystoreType.JKS.toString() + " is preferred.");
        }
        return KeyStoreUtils.getKeyStore(trustStoreType);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

