/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script.engine;

import clojure.lang.Associative;
import clojure.lang.Compiler;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.Namespace;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.Reader;
import java.io.StringReader;
import java.util.UUID;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class ClojureScriptEngine
extends AbstractScriptEngine {
    public static final String ENGINE_NAME = "Clojure";
    public static final String ENGINE_VERSION = "1.8.0";
    private volatile ScriptEngineFactory scriptEngineFactory;
    private final String uuid = "ns-" + UUID.randomUUID().toString();
    private final Symbol NAMESPACE_SYMBOL = Symbol.create((String)this.uuid);

    protected ClojureScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineFactory = scriptEngineFactory;
        Bindings engineScope = this.getBindings(100);
        engineScope.put("javax.script.engine", (Object)ENGINE_NAME);
        engineScope.put(ENGINE_VERSION, (Object)ENGINE_VERSION);
        engineScope.put("javax.script.name", (Object)ENGINE_NAME);
        engineScope.put("javax.script.language", (Object)ENGINE_NAME);
        engineScope.put("javax.script.language_version", (Object)ENGINE_VERSION);
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("script is null");
        }
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try {
            Object result;
            Bindings engineBindings = context.getBindings(100);
            engineBindings.entrySet().forEach(entry -> Var.intern((Namespace)Namespace.findOrCreate((Symbol)this.NAMESPACE_SYMBOL), (Symbol)Symbol.create((String)((String)entry.getKey()).intern()), entry.getValue(), (boolean)true));
            Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{RT.CURRENT_NS, RT.CURRENT_NS.deref(), RT.IN, new LineNumberingPushbackReader(context.getReader()), RT.OUT, context.getWriter(), RT.ERR, context.getErrorWriter()}));
            Object object = result = Compiler.load((Reader)reader);
            return object;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            Namespace.remove((Symbol)this.NAMESPACE_SYMBOL);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.scriptEngineFactory;
    }

    public String getNamespace() {
        return this.uuid;
    }
}

