/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script;

import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.script.ScriptedRouterProcessor;

@Tags(value={"record", "filter", "script", "groovy"})
@CapabilityDescription(value="This processor provides the ability to filter records out from FlowFiles using the user-provided script. Every record will be evaluated by the script which must return with a boolean value. Records with \"true\" result will be routed to the \"matching\" relationship in a batch. Other records will be filtered out.")
@SeeAlso(classNames={"org.apache.nifi.processors.script.ScriptedTransformRecord", "org.apache.nifi.processors.script.ScriptedValidateRecord", "org.apache.nifi.processors.script.ScriptedPartitionRecord"})
public class ScriptedFilterRecord
extends ScriptedRouterProcessor<Boolean> {
    static final Relationship RELATIONSHIP_SUCCESS = new Relationship.Builder().name("success").description("Matching records of the original FlowFile will be routed to this relationship. If there are no matching records, no FlowFile will be routed here.").build();
    static final Relationship RELATIONSHIP_ORIGINAL = new Relationship.Builder().name("original").description("After successful procession, the incoming FlowFile will be transferred to this relationship. This happens regardless the number of filtered or remaining records.").build();
    static final Relationship RELATIONSHIP_FAILURE = new Relationship.Builder().name("failure").description("In case of any issue during processing the incoming FlowFile, the incoming FlowFile will be routed to this relationship.").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(RELATIONSHIP_ORIGINAL, RELATIONSHIP_FAILURE, RELATIONSHIP_SUCCESS);

    public ScriptedFilterRecord() {
        super(Boolean.class);
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @Override
    protected Relationship getOriginalRelationship() {
        return RELATIONSHIP_ORIGINAL;
    }

    @Override
    protected Relationship getFailureRelationship() {
        return RELATIONSHIP_FAILURE;
    }

    @Override
    protected Optional<Relationship> resolveRelationship(Boolean scriptResult) {
        return scriptResult != false ? Optional.of(RELATIONSHIP_SUCCESS) : Optional.empty();
    }
}

