/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.inference;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class FieldTypeInference {
    private static final DataType DEFAULT_DATA_TYPE = RecordFieldType.STRING.getDataType();
    private DataType singleDataType = null;
    private final Set<DataType> possibleDataTypes = new HashSet<DataType>();

    public void addPossibleDataType(DataType dataType) {
        RecordFieldType possibleFieldType;
        if (dataType == null) {
            return;
        }
        if (this.singleDataType == null) {
            this.singleDataType = dataType;
            return;
        }
        if (this.singleDataType.equals((Object)dataType) || this.possibleDataTypes.contains(dataType)) {
            return;
        }
        RecordFieldType singleFieldType = this.singleDataType.getFieldType();
        RecordFieldType additionalFieldType = dataType.getFieldType();
        if (singleFieldType == RecordFieldType.RECORD && additionalFieldType == RecordFieldType.RECORD) {
            RecordSchema singleDataTypeSchema = ((RecordDataType)this.singleDataType).getChildSchema();
            RecordSchema newSchema = ((RecordDataType)dataType).getChildSchema();
            RecordSchema mergedSchema = DataTypeUtils.merge((RecordSchema)singleDataTypeSchema, (RecordSchema)newSchema);
            this.possibleDataTypes.remove(this.singleDataType);
            this.singleDataType = RecordFieldType.RECORD.getRecordDataType(mergedSchema);
            this.possibleDataTypes.add(this.singleDataType);
            return;
        }
        if (this.possibleDataTypes.isEmpty()) {
            this.possibleDataTypes.add(this.singleDataType);
        }
        for (DataType possibleDataType : this.possibleDataTypes) {
            possibleFieldType = possibleDataType.getFieldType();
            if (possibleFieldType.equals((Object)RecordFieldType.STRING) || !possibleFieldType.isWiderThan(additionalFieldType)) continue;
            return;
        }
        Iterator<DataType> possibleDataTypeIterator = this.possibleDataTypes.iterator();
        while (possibleDataTypeIterator.hasNext()) {
            DataType possibleDataType;
            possibleDataType = possibleDataTypeIterator.next();
            possibleFieldType = possibleDataType.getFieldType();
            if (additionalFieldType.equals((Object)RecordFieldType.STRING) || !additionalFieldType.isWiderThan(possibleFieldType)) continue;
            possibleDataTypeIterator.remove();
        }
        this.possibleDataTypes.add(dataType);
    }

    public DataType toDataType() {
        if (this.possibleDataTypes.isEmpty()) {
            if (this.singleDataType == null) {
                return DEFAULT_DATA_TYPE;
            }
            return this.singleDataType;
        }
        DataType aggregate = null;
        for (DataType dataType : this.possibleDataTypes) {
            aggregate = DataTypeUtils.mergeDataTypes(aggregate, (DataType)dataType);
        }
        return aggregate;
    }
}

