/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.rules.Action;
import org.apache.nifi.rules.handlers.AbstractActionHandlerService;

@Tags(value={"rules", "rules engine", "action", "action handler", "logging"})
@CapabilityDescription(value="Logs messages and fact information based on a provided action (usually created by a rules engine).   Action objects executed with this Handler should contain \"logLevel\" and \"message\" attributes.")
public class LogHandler
extends AbstractActionHandlerService {
    public static final PropertyDescriptor DEFAULT_LOG_LEVEL = new PropertyDescriptor.Builder().name("logger-default-log-level").displayName("Default Log Level").required(true).description("If a log level is not provided as an attribute within an Action, the default log level will be used.").allowableValues((Enum[])AbstractActionHandlerService.DebugLevels.values()).defaultValue("info").build();
    public static final PropertyDescriptor DEFAULT_LOG_MESSAGE = new PropertyDescriptor.Builder().name("logger-default-log-message").displayName("Default Log Message").required(true).description("If a log message is not provided as an attribute within an Action, the default log message will be used.").defaultValue("Rules Action Triggered Log.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    private static final PropertyDescriptor LOG_FACTS = new PropertyDescriptor.Builder().name("log-facts").displayName("Log Facts").required(true).description("If true, the log message will include the facts which triggered this log action.").defaultValue("true").allowableValues(new String[]{"true", "false"}).build();
    private static final PropertyDescriptor LOG_PREFIX = new PropertyDescriptor.Builder().name("log-prefix").displayName("Log Prefix").required(false).description("Log prefix appended to the log lines. It helps to distinguish the output of multiple LogAttribute processors.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    private List<PropertyDescriptor> properties;
    private String logPrefix;
    private Boolean logFacts;
    private String defaultLogLevel;
    private String defaultLogMessage;

    protected void init(ControllerServiceInitializationContext config) throws InitializationException {
        super.init(config);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(LOG_PREFIX);
        properties.add(LOG_FACTS);
        properties.add(DEFAULT_LOG_LEVEL);
        properties.add(DEFAULT_LOG_MESSAGE);
        properties.add(ENFORCE_ACTION_TYPE);
        properties.add(ENFORCE_ACTION_TYPE_LEVEL);
        this.properties = Collections.unmodifiableList(properties);
    }

    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        super.onEnabled(context);
        this.logPrefix = context.getProperty(LOG_PREFIX).evaluateAttributeExpressions().getValue();
        this.logFacts = context.getProperty(LOG_FACTS).asBoolean();
        this.defaultLogLevel = context.getProperty(DEFAULT_LOG_LEVEL).getValue().toUpperCase();
        this.defaultLogMessage = context.getProperty(DEFAULT_LOG_MESSAGE).evaluateAttributeExpressions().getValue();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @Override
    protected void executeAction(PropertyContext propertyContext, Action action, Map<String, Object> facts) {
        this.executeAction(action, facts);
    }

    @Override
    protected void executeAction(Action action, Map<String, Object> facts) {
        ComponentLog logger = this.getLogger();
        Map attributes = action.getAttributes();
        String logLevel = (String)attributes.get("logLevel");
        LogLevel level = this.getLogLevel(logLevel, LogLevel.valueOf((String)this.defaultLogLevel));
        String eventMessage = StringUtils.isNotEmpty((CharSequence)((CharSequence)attributes.get("message"))) ? (String)attributes.get("message") : this.defaultLogMessage;
        String factsMessage = this.createFactsLogMessage(facts, eventMessage);
        logger.log(level, factsMessage);
    }

    private LogLevel getLogLevel(String logLevel, LogLevel defaultLevel) {
        LogLevel level;
        if (StringUtils.isNotEmpty((CharSequence)logLevel)) {
            try {
                level = LogLevel.valueOf((String)logLevel.toUpperCase());
            }
            catch (IllegalArgumentException iea) {
                level = defaultLevel;
            }
        } else {
            level = defaultLevel;
        }
        return level;
    }

    protected String createFactsLogMessage(Map<String, Object> facts, String eventMessage) {
        String dashedLine;
        Set<String> fields = facts.keySet();
        StringBuilder message = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)this.logPrefix)) {
            dashedLine = StringUtils.repeat((char)'-', (int)50);
        } else {
            this.logPrefix = StringUtils.abbreviate((String)this.logPrefix, (int)40);
            this.logPrefix = StringUtils.center((String)this.logPrefix, (int)40, (char)'-');
            dashedLine = StringUtils.repeat((char)'-', (int)5) + this.logPrefix + StringUtils.repeat((char)'-', (int)5);
        }
        message.append("\n");
        message.append(dashedLine);
        message.append("\n");
        message.append("Log Message: ");
        message.append(eventMessage);
        message.append("\n");
        if (this.logFacts.booleanValue()) {
            message.append("Log Facts:\n");
            fields.forEach(field -> {
                message.append("Field: ");
                message.append((String)field);
                message.append(", Value: ");
                message.append(facts.get(field));
                message.append("\n");
            });
        }
        return message.toString().trim();
    }
}

