/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.rules.Action;
import org.apache.nifi.rules.handlers.AbstractActionHandlerService;

@Tags(value={"rules", "rules engine", "action", "action handler", "logging", "alerts", "bulletins"})
@CapabilityDescription(value="Creates alerts as bulletins based on a provided action (usually created by a rules engine).  Action objects executed with this Handler should contain \"category\", \"message\", and \"logLevel\" attributes.")
public class AlertHandler
extends AbstractActionHandlerService {
    public static final PropertyDescriptor DEFAULT_LOG_LEVEL = new PropertyDescriptor.Builder().name("alert-default-log-level").displayName("Default Alert Log Level").required(true).description("The default Log Level that will be used to log an alert message if a log level was not provided in the received action's attributes.").allowableValues((Enum[])AbstractActionHandlerService.DebugLevels.values()).defaultValue("info").build();
    public static final PropertyDescriptor DEFAULT_CATEGORY = new PropertyDescriptor.Builder().name("alert-default-category").displayName("Default Category").required(true).description("The default category to use when logging alert message  if a category was not provided in the received action's attributes.").defaultValue("Rules Triggered Alert").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DEFAULT_MESSAGE = new PropertyDescriptor.Builder().name("alert-default-message").displayName("Default Message").required(true).description("The default message to include in alert if an alert message was not provided in the received action's attributes").defaultValue("An alert was triggered by a rules-based action.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final PropertyDescriptor INCLUDE_FACTS = new PropertyDescriptor.Builder().name("alert-include-facts").displayName("Include Fact Data").required(true).description("If true, the alert message will include the facts which triggered this action. Default is false.").defaultValue("true").allowableValues(new String[]{"true", "false"}).build();
    private List<PropertyDescriptor> properties;
    private String defaultCategory;
    private String defaultLogLevel;
    private String defaultMessage;
    private Boolean includeFacts;

    protected void init(ControllerServiceInitializationContext config) throws InitializationException {
        super.init(config);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(DEFAULT_LOG_LEVEL);
        properties.add(DEFAULT_CATEGORY);
        properties.add(DEFAULT_MESSAGE);
        properties.add(INCLUDE_FACTS);
        properties.add(ENFORCE_ACTION_TYPE);
        properties.add(ENFORCE_ACTION_TYPE_LEVEL);
        this.properties = Collections.unmodifiableList(properties);
    }

    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        super.onEnabled(context);
        this.defaultLogLevel = context.getProperty(DEFAULT_LOG_LEVEL).getValue().toUpperCase();
        this.defaultCategory = context.getProperty(DEFAULT_CATEGORY).getValue();
        this.defaultMessage = context.getProperty(DEFAULT_MESSAGE).getValue();
        this.includeFacts = context.getProperty(INCLUDE_FACTS).asBoolean();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @Override
    protected void executeAction(PropertyContext propertyContext, Action action, Map<String, Object> facts) {
        ComponentLog logger = this.getLogger();
        if (propertyContext instanceof ReportingContext) {
            ReportingContext context = (ReportingContext)propertyContext;
            Map attributes = action.getAttributes();
            if (context.getBulletinRepository() != null) {
                Severity severity;
                String category = attributes.getOrDefault("category", this.defaultCategory);
                String message = this.getMessage(attributes.getOrDefault("message", this.defaultMessage), facts);
                String level = attributes.getOrDefault("severity", attributes.getOrDefault("logLevel", this.defaultLogLevel));
                try {
                    severity = Severity.valueOf((String)level.toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    severity = Severity.INFO;
                }
                BulletinRepository bulletinRepository = context.getBulletinRepository();
                bulletinRepository.addBulletin(context.createBulletin(category, severity, message));
            } else {
                logger.warn("Bulletin Repository is not available which is unusual. Cannot send a bulletin.");
            }
        } else {
            logger.warn("Reporting context was not provided to create bulletins.");
        }
    }

    protected String getMessage(String alertMessage, Map<String, Object> facts) {
        if (this.includeFacts.booleanValue()) {
            StringBuilder message = new StringBuilder(alertMessage);
            Set<String> fields = facts.keySet();
            message.append("\n");
            message.append("Alert Facts:\n");
            fields.forEach(field -> {
                message.append("Field: ");
                message.append((String)field);
                message.append(", Value: ");
                message.append(facts.get(field));
                message.append("\n");
            });
            return message.toString();
        }
        return alertMessage;
    }
}

