/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.rules.Action;
import org.apache.nifi.rules.PropertyContextActionHandler;
import org.apache.nifi.rules.handlers.AbstractActionHandlerService;

@Tags(value={"rules", "rules engine", "action", "action handler", "lookup"})
@CapabilityDescription(value="Provides an Action Handler that can be used to dynamically select another Action Handler. This service will allow multiple ActionHandlers to be defined and registered by action type.  When actions are provided the handlers can be dynamically determined and executed at runtime.")
@DynamicProperty(name="actionType ", value="Action Handler Service", expressionLanguageScope=ExpressionLanguageScope.NONE, description="")
public class ActionHandlerLookup
extends AbstractActionHandlerService {
    private volatile Map<String, PropertyContextActionHandler> actionHandlerMap;

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("The Action handler to return when action type = '" + propertyDescriptorName + "'").identifiesControllerService(PropertyContextActionHandler.class).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        int numDefinedServices = 0;
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (descriptor.isDynamic()) {
                ++numDefinedServices;
            }
            String referencedId = context.getProperty(descriptor).getValue();
            if (!this.getIdentifier().equals(referencedId)) continue;
            results.add(new ValidationResult.Builder().subject(descriptor.getDisplayName()).explanation("the current service cannot be registered as an ActionHandler to lookup").valid(false).build());
        }
        if (numDefinedServices == 0) {
            results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).explanation("at least one Action Handler must be defined via dynamic properties").valid(false).build());
        }
        return results;
    }

    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        HashMap<String, PropertyContextActionHandler> serviceMap = new HashMap<String, PropertyContextActionHandler>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            PropertyContextActionHandler propertyContextActionHandler = (PropertyContextActionHandler)context.getProperty(descriptor).asControllerService(PropertyContextActionHandler.class);
            serviceMap.put(descriptor.getName(), propertyContextActionHandler);
        }
        this.actionHandlerMap = Collections.unmodifiableMap(serviceMap);
    }

    @OnDisabled
    public void onDisabled() {
        this.actionHandlerMap = null;
    }

    @Override
    public void execute(Action action, Map<String, Object> facts) {
        this.execute(null, action, facts);
    }

    @Override
    public void execute(PropertyContext context, Action action, Map<String, Object> facts) {
        PropertyContextActionHandler actionHandler = this.actionHandlerMap.get(action.getType());
        if (actionHandler == null) {
            throw new ProcessException("No Action Handler was found for Action Type:" + action.getType());
        }
        actionHandler.execute(context, action, facts);
    }
}

