/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.rules.Action;
import org.apache.nifi.rules.PropertyContextActionHandler;

public abstract class AbstractActionHandlerService
extends AbstractControllerService
implements PropertyContextActionHandler {
    protected List<String> enforceActionTypes;
    protected EnforceActionTypeLevel enforceActionTypeLevel;
    public static final PropertyDescriptor ENFORCE_ACTION_TYPE = new PropertyDescriptor.Builder().name("action-handler-enforce-type").displayName("Enforce Action Type").required(false).description("The Action Type(s) that should be supported by this handler.  If provided any other type an exception will be thrown.  This can support a comma delimited list of types (e.g. ALERT,LOG)").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor ENFORCE_ACTION_TYPE_LEVEL = new PropertyDescriptor.Builder().name("action-handler-enforce-type-level").displayName("Enforce Level").required(false).description("If specific action types are enforced, this setting specifies whether the action should be ignored, a warning should be logged or if an exception is thrown. Default is to ignore the received action.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).allowableValues((Enum[])EnforceActionTypeLevel.values()).defaultValue("IGNORE").build();

    public void execute(Action action, Map<String, Object> facts) {
        if (this.actionTypeNotSupported(action)) {
            this.handleActionEnforcement(action);
        } else {
            this.executeAction(action, facts);
        }
    }

    public void execute(PropertyContext context, Action action, Map<String, Object> facts) {
        if (this.actionTypeNotSupported(action)) {
            this.handleActionEnforcement(action);
        } else {
            this.executeAction(context, action, facts);
        }
    }

    protected void executeAction(Action action, Map<String, Object> facts) {
        throw new UnsupportedOperationException("This method is not supported by this handler.");
    }

    protected void executeAction(PropertyContext propertyContext, Action action, Map<String, Object> facts) {
        throw new UnsupportedOperationException("This method is not supported by this handler");
    }

    protected boolean actionTypeNotSupported(Action action) {
        return this.enforceActionTypes != null && !this.enforceActionTypes.contains(action.getType());
    }

    protected void handleActionEnforcement(Action action) {
        String message = "This Action Handler does not support actions with the provided type: " + action.getType();
        if (this.enforceActionTypeLevel.equals((Object)EnforceActionTypeLevel.WARN)) {
            this.getLogger().warn(message);
        } else {
            if (this.enforceActionTypeLevel.equals((Object)EnforceActionTypeLevel.EXCEPTION)) {
                throw new UnsupportedOperationException(message);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message);
            }
        }
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        String level;
        String actionTypes = context.getProperty(ENFORCE_ACTION_TYPE).evaluateAttributeExpressions().getValue();
        if (StringUtils.isNotEmpty((CharSequence)actionTypes)) {
            this.enforceActionTypes = Arrays.stream(actionTypes.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        }
        if (StringUtils.isNotEmpty((CharSequence)(level = context.getProperty(ENFORCE_ACTION_TYPE_LEVEL).getValue()))) {
            this.enforceActionTypeLevel = EnforceActionTypeLevel.valueOf(level);
        }
    }

    public static enum EnforceActionTypeLevel {
        IGNORE,
        WARN,
        EXCEPTION;

    }

    public static enum DebugLevels {
        trace,
        debug,
        info,
        warn,
        error;

    }
}

