/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.processor.Relationship;

public class StandardRepositoryRecord
implements RepositoryRecord {
    private RepositoryRecordType type;
    private FlowFileRecord workingFlowFileRecord = null;
    private Relationship transferRelationship = null;
    private FlowFileQueue destination = null;
    private final FlowFileRecord originalFlowFileRecord;
    private final FlowFileQueue originalQueue;
    private String swapLocation;
    private final Map<String, String> originalAttributes;
    private Map<String, String> updatedAttributes = null;
    private List<ContentClaim> transientClaims;
    private final long startNanos = System.nanoTime();
    private boolean contentModified;

    public StandardRepositoryRecord(FlowFileQueue originalQueue) {
        this(originalQueue, null);
        this.setType(RepositoryRecordType.CREATE);
    }

    public StandardRepositoryRecord(FlowFileQueue originalQueue, FlowFileRecord originalFlowFileRecord) {
        this(originalQueue, originalFlowFileRecord, null);
        this.setType(RepositoryRecordType.UPDATE);
    }

    public StandardRepositoryRecord(FlowFileQueue originalQueue, FlowFileRecord originalFlowFileRecord, String swapLocation) {
        this.originalQueue = originalQueue;
        this.originalFlowFileRecord = originalFlowFileRecord;
        this.setType(RepositoryRecordType.SWAP_OUT);
        this.swapLocation = swapLocation;
        this.originalAttributes = originalFlowFileRecord == null ? Collections.emptyMap() : originalFlowFileRecord.getAttributes();
    }

    public StandardRepositoryRecord(Collection<ContentClaim> transientClaims) {
        this.originalQueue = null;
        this.originalFlowFileRecord = null;
        this.originalAttributes = Collections.emptyMap();
        this.setType(RepositoryRecordType.CLEANUP_TRANSIENT_CLAIMS);
        transientClaims.forEach(this::addTransientClaim);
    }

    public FlowFileQueue getDestination() {
        return this.destination;
    }

    public void setDestination(FlowFileQueue destination) {
        this.destination = destination;
    }

    public RepositoryRecordType getType() {
        return this.type;
    }

    FlowFileRecord getOriginal() {
        return this.originalFlowFileRecord;
    }

    public String getSwapLocation() {
        return this.swapLocation;
    }

    public void setSwapLocation(String swapLocation) {
        this.swapLocation = swapLocation;
        if (this.type != RepositoryRecordType.SWAP_OUT) {
            this.setType(RepositoryRecordType.SWAP_IN);
        }
    }

    public ContentClaim getOriginalClaim() {
        return this.originalFlowFileRecord == null ? null : this.originalFlowFileRecord.getContentClaim();
    }

    public FlowFileQueue getOriginalQueue() {
        return this.originalQueue;
    }

    public void setWorking(FlowFileRecord flowFile, boolean contentModified) {
        this.workingFlowFileRecord = flowFile;
        this.contentModified |= contentModified;
    }

    private Map<String, String> initializeUpdatedAttributes() {
        if (this.updatedAttributes == null) {
            this.updatedAttributes = new HashMap<String, String>();
        }
        return this.updatedAttributes;
    }

    public void setWorking(FlowFileRecord flowFile, String attributeKey, String attributeValue, boolean contentModified) {
        this.workingFlowFileRecord = flowFile;
        this.contentModified |= contentModified;
        if (this.type == RepositoryRecordType.CREATE) {
            return;
        }
        String currentValue = this.originalAttributes.get(attributeKey);
        if (currentValue == null || !currentValue.equals(attributeValue)) {
            this.initializeUpdatedAttributes().put(attributeKey, attributeValue);
        }
    }

    public void setWorking(FlowFileRecord flowFile, Map<String, String> updatedAttribs, boolean contentModified) {
        this.workingFlowFileRecord = flowFile;
        this.contentModified |= contentModified;
        if (this.type == RepositoryRecordType.CREATE) {
            return;
        }
        for (Map.Entry<String, String> entry : updatedAttribs.entrySet()) {
            String currentValue = this.originalAttributes.get(entry.getKey());
            if (currentValue != null && currentValue.equals(entry.getValue())) continue;
            this.initializeUpdatedAttributes().put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isAttributesChanged() {
        return this.type == RepositoryRecordType.CREATE || this.updatedAttributes != null && !this.updatedAttributes.isEmpty();
    }

    public void markForAbort() {
        this.setType(RepositoryRecordType.CONTENTMISSING);
    }

    public boolean isMarkedForAbort() {
        return RepositoryRecordType.CONTENTMISSING.equals((Object)this.type);
    }

    public void markForDelete() {
        this.setType(RepositoryRecordType.DELETE);
    }

    public boolean isMarkedForDelete() {
        return RepositoryRecordType.DELETE.equals((Object)this.type);
    }

    public void setTransferRelationship(Relationship relationship) {
        this.transferRelationship = relationship;
        if (relationship == Relationship.SELF && this.isMarkedForDelete() && this.originalFlowFileRecord != null && this.originalQueue != null) {
            this.setType(RepositoryRecordType.UPDATE);
        }
    }

    public Relationship getTransferRelationship() {
        return this.transferRelationship;
    }

    ContentClaim getWorkingClaim() {
        return this.workingFlowFileRecord == null ? null : this.workingFlowFileRecord.getContentClaim();
    }

    public FlowFileRecord getCurrent() {
        return this.workingFlowFileRecord == null ? this.originalFlowFileRecord : this.workingFlowFileRecord;
    }

    public ContentClaim getCurrentClaim() {
        return this.getCurrent() == null ? null : this.getCurrent().getContentClaim();
    }

    public long getCurrentClaimOffset() {
        return this.getCurrent() == null ? 0L : this.getCurrent().getContentClaimOffset();
    }

    Map<String, String> getOriginalAttributes() {
        return this.originalAttributes;
    }

    Map<String, String> getUpdatedAttributes() {
        if (this.type == RepositoryRecordType.CREATE) {
            return this.getCurrent().getAttributes();
        }
        return this.updatedAttributes == null ? Collections.emptyMap() : this.updatedAttributes;
    }

    private void setType(RepositoryRecordType newType) {
        if (newType == this.type) {
            return;
        }
        if (this.type == RepositoryRecordType.CREATE) {
            this.updatedAttributes = new HashMap<String, String>(this.getCurrent().getAttributes());
        }
        this.type = newType;
    }

    public String toString() {
        return "StandardRepositoryRecord[UpdateType=" + String.valueOf(this.getType()) + ",Record=" + String.valueOf(this.getCurrent()) + "]";
    }

    public List<ContentClaim> getTransientClaims() {
        return this.transientClaims == null ? Collections.emptyList() : Collections.unmodifiableList(this.transientClaims);
    }

    void addTransientClaim(ContentClaim claim) {
        if (claim == null) {
            return;
        }
        if (this.transientClaims == null) {
            this.transientClaims = new ArrayList<ContentClaim>();
        }
        this.transientClaims.add(claim);
    }

    public long getStartNanos() {
        return this.startNanos;
    }

    public boolean isContentModified() {
        return this.contentModified;
    }
}

