/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.util.provenance;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.reporting.util.provenance.ParentProcessGroupSearchNode;

public class ComponentMapHolder {
    private static final String REMOTE_INPUT_PORT = "Remote Input Port";
    private static final String REMOTE_OUTPUT_PORT = "Remote Output Port";
    private final Map<String, String> componentNameMap = new HashMap<String, String>();
    private final Map<String, ParentProcessGroupSearchNode> componentToParentGroupMap = new HashMap<String, ParentProcessGroupSearchNode>();
    private final Map<String, String> sourceToConnectionParentGroupMap = new HashMap<String, String>();
    private final Map<String, String> destinationToConnectionParentGroupMap = new HashMap<String, String>();

    private ComponentMapHolder putAll(ComponentMapHolder holder) {
        this.componentNameMap.putAll(holder.componentNameMap);
        this.componentToParentGroupMap.putAll(holder.componentToParentGroupMap);
        this.sourceToConnectionParentGroupMap.putAll(holder.sourceToConnectionParentGroupMap);
        this.destinationToConnectionParentGroupMap.putAll(holder.destinationToConnectionParentGroupMap);
        return this;
    }

    public String getComponentName(String componentId) {
        return this.componentNameMap.get(componentId);
    }

    public String getProcessGroupId(String componentId, String componentType) {
        if (REMOTE_INPUT_PORT.equals(componentType)) {
            return this.destinationToConnectionParentGroupMap.get(componentId);
        }
        if (REMOTE_OUTPUT_PORT.equals(componentType)) {
            return this.sourceToConnectionParentGroupMap.get(componentId);
        }
        ParentProcessGroupSearchNode parentNode = this.componentToParentGroupMap.get(componentId);
        return parentNode == null ? null : parentNode.getId();
    }

    public ParentProcessGroupSearchNode getProcessGroupParent(String componentId) {
        return this.componentToParentGroupMap.get(componentId);
    }

    public static ComponentMapHolder createComponentMap(ProcessGroupStatus status) {
        return ComponentMapHolder.createComponentMap(status, new ParentProcessGroupSearchNode(status.getId(), null));
    }

    private static ComponentMapHolder createComponentMap(ProcessGroupStatus status, ParentProcessGroupSearchNode thisProcessGroupNode) {
        ComponentMapHolder holder = new ComponentMapHolder();
        Map<String, String> componentNameMap = holder.componentNameMap;
        Map<String, ParentProcessGroupSearchNode> componentToParentGroupMap = holder.componentToParentGroupMap;
        Map<String, String> sourceToConnectionParentGroupMap = holder.sourceToConnectionParentGroupMap;
        Map<String, String> destinationToConnectionParentGroupMap = holder.destinationToConnectionParentGroupMap;
        if (status != null) {
            componentNameMap.put(status.getId(), status.getName());
            for (ProcessorStatus procStatus : status.getProcessorStatus()) {
                componentNameMap.put(procStatus.getId(), procStatus.getName());
                componentToParentGroupMap.put(procStatus.getId(), thisProcessGroupNode);
            }
            for (PortStatus portStatus : status.getInputPortStatus()) {
                componentNameMap.put(portStatus.getId(), portStatus.getName());
                componentToParentGroupMap.put(portStatus.getId(), thisProcessGroupNode);
            }
            for (PortStatus portStatus : status.getOutputPortStatus()) {
                componentNameMap.put(portStatus.getId(), portStatus.getName());
                componentToParentGroupMap.put(portStatus.getId(), thisProcessGroupNode);
            }
            for (RemoteProcessGroupStatus rpgStatus : status.getRemoteProcessGroupStatus()) {
                componentNameMap.put(rpgStatus.getId(), rpgStatus.getName());
                componentToParentGroupMap.put(rpgStatus.getId(), thisProcessGroupNode);
            }
            for (ConnectionStatus connectionStatus : status.getConnectionStatus()) {
                componentNameMap.put(connectionStatus.getId(), connectionStatus.getName());
                componentToParentGroupMap.put(connectionStatus.getId(), thisProcessGroupNode);
                componentNameMap.computeIfAbsent(connectionStatus.getSourceId(), k -> connectionStatus.getSourceName());
                componentNameMap.computeIfAbsent(connectionStatus.getDestinationId(), k -> connectionStatus.getDestinationName());
                sourceToConnectionParentGroupMap.put(connectionStatus.getSourceId(), connectionStatus.getGroupId());
                destinationToConnectionParentGroupMap.put(connectionStatus.getDestinationId(), connectionStatus.getGroupId());
            }
            for (ProcessGroupStatus childGroup : status.getProcessGroupStatus()) {
                componentNameMap.put(childGroup.getId(), childGroup.getName());
                ParentProcessGroupSearchNode childProcessGroupNode = new ParentProcessGroupSearchNode(childGroup.getId(), thisProcessGroupNode);
                componentToParentGroupMap.put(childGroup.getId(), thisProcessGroupNode);
                holder.putAll(ComponentMapHolder.createComponentMap(childGroup, childProcessGroupNode));
            }
        }
        return holder;
    }
}

