/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.redis.state;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.redis.state.RedisStateMap;
import org.apache.nifi.redis.state.RedisStateMapSerDe;

public class RedisStateMapJsonSerDe
implements RedisStateMapSerDe {
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_ENCODING = "encodingVersion";
    public static final String FIELD_STATE_VALUES = "stateValues";
    static final long EMPTY_VERSION = -1L;
    private final JsonFactory jsonFactory = new JsonFactory((ObjectCodec)new ObjectMapper());

    @Override
    public byte[] serialize(RedisStateMap stateMap) throws IOException {
        if (stateMap == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            JsonGenerator jsonGenerator = this.jsonFactory.createGenerator((OutputStream)out);
            jsonGenerator.writeStartObject();
            Optional<String> stateVersion = stateMap.getStateVersion();
            long version = stateVersion.map(Long::parseLong).orElse(-1L);
            jsonGenerator.writeNumberField(FIELD_VERSION, version);
            jsonGenerator.writeNumberField(FIELD_ENCODING, stateMap.getEncodingVersion().intValue());
            jsonGenerator.writeObjectFieldStart(FIELD_STATE_VALUES);
            for (Map.Entry<String, String> entry : stateMap.toMap().entrySet()) {
                jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
            jsonGenerator.flush();
            Object object = out.toByteArray();
            return object;
        }
    }

    @Override
    public RedisStateMap deserialize(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return null;
        }
        RedisStateMap.Builder builder = new RedisStateMap.Builder();
        try (JsonParser jsonParser = this.jsonFactory.createParser(data);){
            JsonNode rootNode = (JsonNode)jsonParser.readValueAsTree();
            builder.version(rootNode.get(FIELD_VERSION).asLong());
            builder.encodingVersion(rootNode.get(FIELD_ENCODING).asInt());
            JsonNode stateValuesNode = rootNode.get(FIELD_STATE_VALUES);
            stateValuesNode.properties().iterator().forEachRemaining(e -> builder.stateValue((String)e.getKey(), ((JsonNode)e.getValue()).asText()));
        }
        return builder.build();
    }
}

