/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ranger.authorization;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.authorization.AuthorizationAuditor;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.UserContextKeys;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.ranger.authorization.RangerBasePluginWithPolicies;
import org.apache.nifi.util.NiFiProperties;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerNiFiAuthorizer
implements Authorizer,
AuthorizationAuditor {
    private static final Logger logger = LoggerFactory.getLogger(RangerNiFiAuthorizer.class);
    static final String RANGER_AUDIT_PATH_PROP = "Ranger Audit Config Path";
    static final String RANGER_SECURITY_PATH_PROP = "Ranger Security Config Path";
    static final String RANGER_KERBEROS_ENABLED_PROP = "Ranger Kerberos Enabled";
    static final String RANGER_ADMIN_IDENTITY_PROP = "Ranger Admin Identity";
    static final String RANGER_SERVICE_TYPE_PROP = "Ranger Service Type";
    static final String RANGER_APP_ID_PROP = "Ranger Application Id";
    static final String RANGER_NIFI_RESOURCE_NAME = "nifi-resource";
    static final String DEFAULT_SERVICE_TYPE = "nifi";
    static final String DEFAULT_APP_ID = "nifi";
    static final String RESOURCES_RESOURCE = "/resources";
    static final String HADOOP_SECURITY_AUTHENTICATION = "hadoop.security.authentication";
    static final String KERBEROS_AUTHENTICATION = "kerberos";
    private final Map<AuthorizationRequest, RangerAccessResult> resultLookup = new WeakHashMap<AuthorizationRequest, RangerAccessResult>();
    private volatile RangerBasePluginWithPolicies nifiPlugin = null;
    private volatile RangerDefaultAuditHandler defaultAuditHandler = null;
    private volatile String rangerAdminIdentity = null;
    private volatile boolean rangerKerberosEnabled = false;
    private volatile NiFiProperties nifiProperties;

    public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        try {
            if (this.nifiPlugin == null) {
                logger.info("RangerNiFiAuthorizer(): initializing base plugin");
                PropertyValue securityConfigValue = configurationContext.getProperty(RANGER_SECURITY_PATH_PROP);
                this.addRequiredResource(RANGER_SECURITY_PATH_PROP, securityConfigValue);
                PropertyValue auditConfigValue = configurationContext.getProperty(RANGER_AUDIT_PATH_PROP);
                this.addRequiredResource(RANGER_AUDIT_PATH_PROP, auditConfigValue);
                String rangerKerberosEnabledValue = this.getConfigValue(configurationContext, RANGER_KERBEROS_ENABLED_PROP, Boolean.FALSE.toString());
                boolean bl = this.rangerKerberosEnabled = rangerKerberosEnabledValue.equals(Boolean.TRUE.toString());
                if (this.rangerKerberosEnabled) {
                    Configuration securityConf = new Configuration();
                    securityConf.set(HADOOP_SECURITY_AUTHENTICATION, KERBEROS_AUTHENTICATION);
                    UserGroupInformation.setConfiguration((Configuration)securityConf);
                    String nifiPrincipal = this.nifiProperties.getKerberosServicePrincipal();
                    String nifiKeytab = this.nifiProperties.getKerberosServiceKeytabLocation();
                    if (StringUtils.isBlank((String)nifiPrincipal) || StringUtils.isBlank((String)nifiKeytab)) {
                        throw new AuthorizerCreationException("Principal and Keytab must be provided when Kerberos is enabled");
                    }
                    UserGroupInformation.loginUserFromKeytab((String)nifiPrincipal.trim(), (String)nifiKeytab.trim());
                }
                String serviceType = this.getConfigValue(configurationContext, RANGER_SERVICE_TYPE_PROP, "nifi");
                String appId = this.getConfigValue(configurationContext, RANGER_APP_ID_PROP, "nifi");
                this.nifiPlugin = this.createRangerBasePlugin(serviceType, appId);
                this.nifiPlugin.init();
                this.defaultAuditHandler = new RangerDefaultAuditHandler();
                this.rangerAdminIdentity = this.getConfigValue(configurationContext, RANGER_ADMIN_IDENTITY_PROP, null);
            } else {
                logger.info("RangerNiFiAuthorizer(): base plugin already initialized");
            }
        }
        catch (Throwable t) {
            throw new AuthorizerCreationException("Error creating RangerBasePlugin", t);
        }
    }

    protected RangerBasePluginWithPolicies createRangerBasePlugin(String serviceType, String appId) {
        return new RangerBasePluginWithPolicies(serviceType, appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
        String identity = request.getIdentity();
        Set userGroups = request.getGroups();
        String resourceIdentifier = request.getResource().getIdentifier();
        if (StringUtils.isNotBlank((String)this.rangerAdminIdentity) && this.rangerAdminIdentity.equals(identity) && resourceIdentifier.equals(RESOURCES_RESOURCE)) {
            return AuthorizationResult.approved();
        }
        String clientIp = request.getUserContext() != null ? (String)request.getUserContext().get(UserContextKeys.CLIENT_ADDRESS.name()) : null;
        RangerAccessResourceImpl resource = new RangerAccessResourceImpl();
        resource.setValue(RANGER_NIFI_RESOURCE_NAME, (Object)resourceIdentifier);
        RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl();
        rangerRequest.setResource((RangerAccessResource)resource);
        rangerRequest.setAction(request.getAction().name());
        rangerRequest.setAccessType(request.getAction().name());
        rangerRequest.setUser(identity);
        rangerRequest.setUserGroups(userGroups);
        rangerRequest.setAccessTime(new Date());
        if (!StringUtils.isBlank((String)clientIp)) {
            rangerRequest.setClientIPAddress(clientIp);
        }
        RangerAccessResult result = this.nifiPlugin.isAccessAllowed((RangerAccessRequest)rangerRequest);
        if (request.isAccessAttempt()) {
            Map<AuthorizationRequest, RangerAccessResult> map = this.resultLookup;
            synchronized (map) {
                this.resultLookup.put(request, result);
            }
        }
        if (result != null && result.getIsAllowed()) {
            return AuthorizationResult.approved();
        }
        boolean doesPolicyExist = this.nifiPlugin.doesPolicyExist(request.getResource().getIdentifier(), request.getAction());
        if (doesPolicyExist) {
            String reason;
            String string = reason = result == null ? null : result.getReason();
            if (reason != null) {
                logger.debug(String.format("Unable to authorize %s due to %s", identity, reason));
            }
            return AuthorizationResult.denied((String)((String)request.getExplanationSupplier().get()));
        }
        return AuthorizationResult.resourceNotFound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void auditAccessAttempt(AuthorizationRequest request, AuthorizationResult result) {
        RangerAccessResult rangerResult;
        Map<AuthorizationRequest, RangerAccessResult> map = this.resultLookup;
        synchronized (map) {
            rangerResult = this.resultLookup.remove(request);
        }
        if (rangerResult != null && rangerResult.getIsAudited()) {
            AuthzAuditEvent event = this.defaultAuditHandler.getAuthzEvents(rangerResult);
            event.setResourceType(RANGER_NIFI_RESOURCE_NAME);
            event.setResourcePath(request.getRequestedResource().getIdentifier());
            this.defaultAuditHandler.logAuthzAudit(event);
        }
    }

    public void preDestruction() throws AuthorizerDestructionException {
        if (this.nifiPlugin != null) {
            try {
                this.nifiPlugin.cleanup();
                this.nifiPlugin = null;
            }
            catch (Throwable t) {
                throw new AuthorizerDestructionException("Error cleaning up RangerBasePlugin", t);
            }
        }
    }

    @AuthorizerContext
    public void setNiFiProperties(NiFiProperties properties) {
        this.nifiProperties = properties;
    }

    private void addRequiredResource(String name, PropertyValue resourceValue) {
        if (resourceValue == null || StringUtils.isBlank((String)resourceValue.getValue())) {
            throw new AuthorizerCreationException(name + " must be specified.");
        }
        File resourceFile = new File(resourceValue.getValue());
        if (!resourceFile.exists() || !resourceFile.canRead()) {
            throw new AuthorizerCreationException(resourceValue + " does not exist, or can not be read");
        }
        try {
            RangerConfiguration.getInstance().addResource(resourceFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new AuthorizerCreationException("Error creating URI for " + resourceValue, (Throwable)e);
        }
    }

    private String getConfigValue(AuthorizerConfigurationContext context, String name, String defaultValue) {
        PropertyValue configValue = context.getProperty(name);
        String retValue = defaultValue;
        if (configValue != null && !StringUtils.isBlank((String)configValue.getValue())) {
            retValue = configValue.getValue();
        }
        return retValue;
    }
}

