/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ranger.authorization;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.util.StringUtils;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerBasePluginWithPolicies
extends RangerBasePlugin {
    private static final Logger logger = LoggerFactory.getLogger(RangerBasePluginWithPolicies.class);
    private static final String WILDCARD_ASTERISK = "*";
    private UserGroupProvider userGroupProvider;
    private AtomicReference<PolicyLookup> policies = new AtomicReference<PolicyLookup>(new PolicyLookup());

    public RangerBasePluginWithPolicies(String serviceType, String appId) {
        this(serviceType, appId, null);
    }

    public RangerBasePluginWithPolicies(String serviceType, String appId, UserGroupProvider userGroupProvider) {
        super(serviceType, appId);
        this.userGroupProvider = userGroupProvider;
    }

    public void setPolicies(ServicePolicies policies) {
        super.setPolicies(policies);
        if (policies == null || policies.getPolicies() == null) {
            this.policies.set(new PolicyLookup());
        } else {
            this.policies.set(this.createPolicyLookup(policies));
        }
    }

    public boolean doesPolicyExist(String resourceIdentifier, RequestAction requestAction) {
        if (resourceIdentifier == null) {
            return false;
        }
        PolicyLookup policyLookup = this.policies.get();
        return policyLookup.getAccessPolicy(resourceIdentifier, requestAction) != null;
    }

    public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
        return this.policies.get().getAccessPolicies();
    }

    public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
        return this.policies.get().getAccessPolicy(identifier);
    }

    public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
        return this.policies.get().getAccessPolicy(resourceIdentifier, action);
    }

    private PolicyLookup createPolicyLookup(ServicePolicies servicePolicies) {
        HashMap policiesByIdentifier = new HashMap();
        HashMap policiesByResource = new HashMap();
        logger.info("Converting Ranger ServicePolicies model into NiFi policy model for viewing purposes in NiFi UI.");
        servicePolicies.getPolicies().stream().forEach(policy -> {
            if (Boolean.TRUE.equals(policy.getIsEnabled())) {
                Set resources = policy.getResources().values().stream().filter(resource -> {
                    boolean isWildcard;
                    boolean isMissingResource;
                    if (resource.getValues() == null) {
                        isMissingResource = true;
                        isWildcard = false;
                    } else {
                        isMissingResource = false;
                        isWildcard = resource.getValues().stream().anyMatch(value -> value.contains(WILDCARD_ASTERISK));
                    }
                    boolean isExclude = Boolean.TRUE.equals(resource.getIsExcludes());
                    boolean isRecursive = Boolean.TRUE.equals(resource.getIsRecursive());
                    if (isMissingResource) {
                        logger.warn("Encountered resources missing values. Skipping policy for viewing purposes. Will still be used for access decisions.");
                    }
                    if (isWildcard) {
                        logger.warn(String.format("Resources [%s] include a wildcard value. Skipping policy for viewing purposes. Will still be used for access decisions.", StringUtils.join((Collection)resource.getValues(), (String)", ")));
                    }
                    if (isExclude) {
                        logger.warn(String.format("Resources [%s] marked as an exclude policy. Skipping policy for viewing purposes. Will still be used for access decisions.", StringUtils.join((Collection)resource.getValues(), (String)", ")));
                    }
                    if (isRecursive) {
                        logger.warn(String.format("Resources [%s] marked as a recursive policy. Skipping policy for viewing purposes. Will still be used for access decisions.", StringUtils.join((Collection)resource.getValues(), (String)", ")));
                    }
                    return !isMissingResource && !isWildcard && !isExclude && !isRecursive;
                }).flatMap(resource -> resource.getValues().stream()).collect(Collectors.toSet());
                policy.getPolicyItems().forEach(policyItem -> {
                    Set userIds = policyItem.getUsers().stream().map(userIdentity -> this.getUser((String)userIdentity)).filter(Objects::nonNull).map(user -> user.getIdentifier()).collect(Collectors.toSet());
                    Set groupIds = policyItem.getGroups().stream().map(groupName -> this.getGroup((String)groupName)).filter(Objects::nonNull).map(group -> group.getIdentifier()).collect(Collectors.toSet());
                    boolean isDelegateAdmin = Boolean.TRUE.equals(policyItem.getDelegateAdmin());
                    policyItem.getAccesses().forEach(access -> {
                        try {
                            RequestAction action = RequestAction.valueOf((String)access.getType());
                            Function<String, AccessPolicy> createPolicy = resource -> new AccessPolicy.Builder().identifierGenerateFromSeed(resource + access.getType()).resource(resource).action(action).addUsers(userIds).addGroups(groupIds).build();
                            resources.forEach(resource -> {
                                AccessPolicy accessPolicy = (AccessPolicy)createPolicy.apply((String)resource);
                                policiesByIdentifier.put(accessPolicy.getIdentifier(), accessPolicy);
                                policiesByResource.computeIfAbsent(resource, r -> new HashMap()).put(action, accessPolicy);
                                if (isDelegateAdmin) {
                                    String adminResource = resource.startsWith("/") ? "/policies" + resource : "/policies/" + resource;
                                    AccessPolicy adminAccessPolicy = (AccessPolicy)createPolicy.apply(adminResource);
                                    policiesByIdentifier.put(adminAccessPolicy.getIdentifier(), adminAccessPolicy);
                                    policiesByResource.computeIfAbsent(adminResource, ar -> new HashMap()).put(action, adminAccessPolicy);
                                }
                            });
                        }
                        catch (IllegalArgumentException e) {
                            logger.warn(String.format("Unrecognized request action '%s'. Skipping policy for viewing purposes. Will still be used for access decisions.", access.getType()));
                        }
                    });
                });
            }
        });
        return new PolicyLookup(policiesByIdentifier, policiesByResource);
    }

    private User getUser(String identity) {
        if (this.userGroupProvider == null) {
            return new User.Builder().identifierGenerateFromSeed(identity).identity(identity).build();
        }
        User user = this.userGroupProvider.getUserByIdentity(identity);
        if (user == null) {
            logger.warn(String.format("Cannot find user '%s' in the configured User Group Provider. Skipping user for viewing purposes. Will still be used for access decisions.", identity));
        }
        return user;
    }

    private Group getGroup(String name) {
        if (this.userGroupProvider == null) {
            return new Group.Builder().identifierGenerateFromSeed(name).name(name).build();
        }
        Group group = this.userGroupProvider.getGroups().stream().filter(g -> g.getName().equals(name)).findFirst().orElse(null);
        if (group == null) {
            logger.warn(String.format("Cannot find group '%s' in the configured User Group Provider. Skipping group for viewing purposes. Will still be used for access decisions.", name));
        }
        return group;
    }

    private static class PolicyLookup {
        private final Map<String, AccessPolicy> policiesByIdentifier;
        private final Map<String, Map<RequestAction, AccessPolicy>> policiesByResource;
        private final Set<AccessPolicy> allPolicies;

        private PolicyLookup() {
            this(null, null);
        }

        private PolicyLookup(Map<String, AccessPolicy> policiesByIdentifier, Map<String, Map<RequestAction, AccessPolicy>> policiesByResource) {
            this.allPolicies = policiesByIdentifier == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet<AccessPolicy>(policiesByIdentifier.values()));
            this.policiesByIdentifier = policiesByIdentifier;
            this.policiesByResource = policiesByResource;
        }

        private Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
            return this.allPolicies;
        }

        private AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
            if (this.policiesByIdentifier == null) {
                return null;
            }
            return this.policiesByIdentifier.get(identifier);
        }

        private AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
            if (this.policiesByResource == null) {
                return null;
            }
            Map<RequestAction, AccessPolicy> policiesForResource = this.policiesByResource.get(resourceIdentifier);
            if (policiesForResource != null) {
                return policiesForResource.get(action);
            }
            return null;
        }
    }
}

