/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ranger.authorization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.UserGroupProviderLookup;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.ranger.authorization.RangerBasePluginWithPolicies;
import org.apache.nifi.ranger.authorization.RangerNiFiAuthorizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManagedRangerAuthorizer
extends RangerNiFiAuthorizer
implements ManagedAuthorizer {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final String USER_GROUP_PROVIDER_ELEMENT = "userGroupProvider";
    private UserGroupProviderLookup userGroupProviderLookup;
    private UserGroupProvider userGroupProvider;
    private RangerBasePluginWithPolicies nifiPlugin;

    @Override
    public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
        this.userGroupProviderLookup = initializationContext.getUserGroupProviderLookup();
        super.initialize(initializationContext);
    }

    @Override
    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        String userGroupProviderKey = configurationContext.getProperty("User Group Provider").getValue();
        this.userGroupProvider = this.userGroupProviderLookup.getUserGroupProvider(userGroupProviderKey);
        if (this.userGroupProvider == null) {
            throw new AuthorizerCreationException(String.format("Unable to locate configured User Group Provider: %s", userGroupProviderKey));
        }
        super.onConfigured(configurationContext);
    }

    @Override
    protected RangerBasePluginWithPolicies createRangerBasePlugin(String serviceType, String appId) {
        this.nifiPlugin = new RangerBasePluginWithPolicies(serviceType, appId, this.userGroupProvider);
        return this.nifiPlugin;
    }

    public AccessPolicyProvider getAccessPolicyProvider() {
        return new AccessPolicyProvider(){

            public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
                return ManagedRangerAuthorizer.this.nifiPlugin.getAccessPolicies();
            }

            public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
                return ManagedRangerAuthorizer.this.nifiPlugin.getAccessPolicy(identifier);
            }

            public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
                return ManagedRangerAuthorizer.this.nifiPlugin.getAccessPolicy(resourceIdentifier, action);
            }

            public UserGroupProvider getUserGroupProvider() {
                return ManagedRangerAuthorizer.this.userGroupProvider;
            }

            public void initialize(AccessPolicyProviderInitializationContext initializationContext) throws AuthorizerCreationException {
            }

            public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
            }

            public void preDestruction() throws AuthorizerDestructionException {
            }
        };
    }

    public String getFingerprint() throws AuthorizationAccessException {
        StringWriter out = new StringWriter();
        try {
            DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element managedRangerAuthorizationsElement = document.createElement("managedRangerAuthorizations");
            document.appendChild(managedRangerAuthorizationsElement);
            Element userGroupProviderElement = document.createElement(USER_GROUP_PROVIDER_ELEMENT);
            managedRangerAuthorizationsElement.appendChild(userGroupProviderElement);
            if (this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
                userGroupProviderElement.appendChild(document.createTextNode(((ConfigurableUserGroupProvider)this.userGroupProvider).getFingerprint()));
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(out));
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new AuthorizationAccessException("Unable to generate fingerprint", (Throwable)e);
        }
        return out.toString();
    }

    public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        if (StringUtils.isBlank((String)fingerprint)) {
            return;
        }
        String userGroupFingerprint = this.parseFingerprint(fingerprint);
        if (StringUtils.isNotBlank((String)userGroupFingerprint) && this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
            ((ConfigurableUserGroupProvider)this.userGroupProvider).inheritFingerprint(userGroupFingerprint);
        }
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
        String userGroupFingerprint = this.parseFingerprint(proposedFingerprint);
        if (StringUtils.isNotBlank((String)userGroupFingerprint)) {
            if (this.userGroupProvider instanceof ConfigurableUserGroupProvider) {
                ((ConfigurableUserGroupProvider)this.userGroupProvider).checkInheritability(userGroupFingerprint);
            } else {
                throw new UninheritableAuthorizationsException("User/Group fingerprint is not blank and the configured UserGroupProvider does not support fingerprinting.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String parseFingerprint(String fingerprint) throws AuthorizationAccessException {
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(fingerprintBytes);){
            DocumentBuilder docBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            Document document = docBuilder.parse(in);
            Element rootElement = document.getDocumentElement();
            NodeList userGroupProviderList = rootElement.getElementsByTagName(USER_GROUP_PROVIDER_ELEMENT);
            if (userGroupProviderList.getLength() != 1) {
                throw new AuthorizationAccessException(String.format("Only one %s element is allowed: %s", USER_GROUP_PROVIDER_ELEMENT, fingerprint));
            }
            Node userGroupProvider = userGroupProviderList.item(0);
            String string = userGroupProvider.getTextContent();
            return string;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new AuthorizationAccessException("Unable to parse fingerprint", (Throwable)e);
        }
    }
}

