/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.embedded;

import java.io.File;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.questdb.DatabaseManager;
import org.apache.nifi.questdb.embedded.EmbeddedDatabaseManager;
import org.apache.nifi.questdb.embedded.ManagedTableDefinition;
import org.apache.nifi.questdb.embedded.SimpleEmbeddedDatabaseManagerContext;
import org.apache.nifi.questdb.rollover.RolloverStrategy;

public final class EmbeddedDatabaseManagerBuilder {
    private SimpleEmbeddedDatabaseManagerContext context = new SimpleEmbeddedDatabaseManagerContext();

    private EmbeddedDatabaseManagerBuilder(String persistPath) {
        this.context.setPersistLocation(persistPath);
    }

    public EmbeddedDatabaseManagerBuilder lockAttemptTime(int lockAttemptTime, TimeUnit lockAttemptTimeUnit) {
        this.context.setLockAttemptDuration(Duration.of(lockAttemptTime, lockAttemptTimeUnit.toChronoUnit()));
        return this;
    }

    public EmbeddedDatabaseManagerBuilder rolloverFrequency(int rolloverFrequency, TimeUnit rolloverFrequencyTimeUnit) {
        this.context.setRolloverFrequencyDuration(Duration.of(rolloverFrequency, rolloverFrequencyTimeUnit.toChronoUnit()));
        return this;
    }

    public EmbeddedDatabaseManagerBuilder numberOfAttemptedRetries(int numberOfAttemptedRetries) {
        this.context.setNumberOfAttemptedRetries(numberOfAttemptedRetries);
        return this;
    }

    public EmbeddedDatabaseManagerBuilder backupLocation(String backupLocation) {
        this.context.setBackupLocation(backupLocation);
        return this;
    }

    public EmbeddedDatabaseManagerBuilder addTable(String name, String definition) {
        return this.addTable(name, definition, RolloverStrategy.keep());
    }

    public EmbeddedDatabaseManagerBuilder addTable(String name, String definition, RolloverStrategy rolloverStrategy) {
        this.context.addTableDefinition(new ManagedTableDefinition(name, definition, rolloverStrategy));
        return this;
    }

    public DatabaseManager build() {
        Objects.requireNonNull(this.context.getLockAttemptTime(), "Lock attempt must be specified");
        if (this.context.getLockAttemptTime().toMillis() <= 0L) {
            throw new IllegalArgumentException("Lock attempt time must be bigger than 0");
        }
        Objects.requireNonNull(this.context.getRolloverFrequency(), "Rollover frequency must be specified");
        if (this.context.getRolloverFrequency().toMillis() <= 0L) {
            throw new IllegalArgumentException("Rollover frequency must be bigger than 0");
        }
        if (this.context.getNumberOfAttemptedRetries() < 1) {
            throw new IllegalArgumentException("Number of attempted retries must be at least 1");
        }
        if (this.context.getTableDefinitions().isEmpty()) {
            throw new IllegalArgumentException("There must be at least on table specified");
        }
        if (this.context.getBackupLocation() == null) {
            this.context.setBackupLocation(new File(this.context.getPersistLocationAsPath().toFile().getParentFile(), "questDbBackup").getAbsolutePath());
        }
        EmbeddedDatabaseManager result = new EmbeddedDatabaseManager(this.context);
        result.init();
        return result;
    }

    public static EmbeddedDatabaseManagerBuilder builder(String persistPath) {
        return new EmbeddedDatabaseManagerBuilder(persistPath);
    }
}

