/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.mapping;

import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.questdb.mapping.RequestMapping;
import org.apache.nifi.questdb.mapping.SimpleRequestMapping;

public final class RequestMappingBuilder<T> {
    private final Supplier<T> factory;
    private final List<Pair<Class<?>, BiConsumer<T, Object>>> fieldMappings = new LinkedList();

    private RequestMappingBuilder(Supplier<T> factory) {
        this.factory = factory;
    }

    public <A> RequestMappingBuilder<T> addField(Class<A> type, BiConsumer<T, A> mapping) {
        this.fieldMappings.add(Pair.of(type, mapping));
        return this;
    }

    public RequestMappingBuilder<T> addStringField(BiConsumer<T, String> mapping) {
        return this.addField(String.class, mapping);
    }

    public RequestMappingBuilder<T> addInstantField(BiConsumer<T, Instant> mapping) {
        return this.addField(Instant.class, mapping);
    }

    public RequestMappingBuilder<T> addLongField(BiConsumer<T, Long> mapping) {
        return this.addField(Long.class, mapping);
    }

    public RequestMappingBuilder<T> addIntegerField(BiConsumer<T, Integer> mapping) {
        return this.addField(Integer.class, mapping);
    }

    public static <E> RequestMappingBuilder<E> of(Supplier<E> factory) {
        return new RequestMappingBuilder<E>(factory);
    }

    public RequestMapping<T> build() {
        if (this.fieldMappings.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one declared field");
        }
        return new SimpleRequestMapping<T>(this.factory, this.fieldMappings);
    }
}

