/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.embedded;

import io.questdb.cairo.TableWriter;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.nifi.questdb.DatabaseException;
import org.apache.nifi.questdb.InsertRowContext;
import org.apache.nifi.questdb.InsertRowDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TableWriterBasedInsertRowContext
implements InsertRowContext {
    public static final Logger LOGGER = LoggerFactory.getLogger(TableWriterBasedInsertRowContext.class);
    private final TableWriter tableWriter;
    private TableWriter.Row actualRow;

    TableWriterBasedInsertRowContext(TableWriter tableWriter) {
        this.tableWriter = tableWriter;
    }

    void addRow(InsertRowDataSource rowDataSource) throws DatabaseException {
        rowDataSource.fillRowData(this);
        this.actualRow.append();
        this.actualRow = null;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Appending new row to the table writer: {}", (Object)this.actualRow);
        }
    }

    @Override
    public InsertRowContext initializeRow(Instant captured) {
        this.actualRow = this.tableWriter.newRow(TableWriterBasedInsertRowContext.instantToMicros(captured));
        return this;
    }

    @Override
    public InsertRowContext addLong(int position, long value) {
        this.actualRow.putLong(position, value);
        return this;
    }

    @Override
    public InsertRowContext addInt(int position, int value) {
        this.actualRow.putInt(position, value);
        return this;
    }

    @Override
    public InsertRowContext addShort(int position, short value) {
        this.actualRow.putShort(position, value);
        return this;
    }

    @Override
    public InsertRowContext addString(int position, String value) {
        this.actualRow.putSym(position, (CharSequence)value);
        return this;
    }

    @Override
    public InsertRowContext addInstant(int position, Instant value) {
        this.actualRow.putTimestamp(position, TableWriterBasedInsertRowContext.instantToMicros(value));
        return this;
    }

    @Override
    public InsertRowContext addTimestamp(int position, long value) {
        this.actualRow.putTimestamp(position, value);
        return this;
    }

    private static long instantToMicros(Instant instant) {
        return ChronoUnit.MICROS.between(Instant.EPOCH, instant);
    }
}

