/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.embedded;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.nifi.questdb.Client;
import org.apache.nifi.questdb.DatabaseException;
import org.apache.nifi.questdb.InsertRowDataSource;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.embedded.LockUnsuccessfulException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LockedClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockedClient.class);
    private final Lock lock;
    private final Duration lockAttemptDuration;
    private final Client client;

    LockedClient(Lock lock, Duration lockAttemptDuration, Client client) {
        this.lock = lock;
        this.lockAttemptDuration = lockAttemptDuration;
        this.client = client;
    }

    @Override
    public void execute(String query) throws DatabaseException {
        this.lockedOperation(() -> {
            this.client.execute(query);
            return null;
        });
    }

    @Override
    public void insert(String tableName, InsertRowDataSource rowSource) throws DatabaseException {
        this.lockedOperation(() -> {
            this.client.insert(tableName, rowSource);
            return null;
        });
    }

    @Override
    public <T> T query(String query, QueryResultProcessor<T> rowProcessor) throws DatabaseException {
        return (T)this.lockedOperation(() -> this.client.query(query, rowProcessor));
    }

    @Override
    public void disconnect() throws DatabaseException {
        this.client.disconnect();
    }

    private <R> R lockedOperation(Callable<R> operation) throws DatabaseException {
        LOGGER.debug("Start locking client {}", (Object)this.client);
        try {
            if (!this.lock.tryLock(this.lockAttemptDuration.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new LockUnsuccessfulException("Could not lock read lock on the database");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new LockUnsuccessfulException(e);
        }
        try {
            LOGGER.debug("Successfully locked client {}", (Object)this.client);
            R e = operation.call();
            return e;
        }
        catch (DatabaseException e) {
            LOGGER.error("Locked operation was unsuccessful", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Locked operation was unsuccessful", (Throwable)e);
            throw new DatabaseException(e);
        }
        finally {
            this.lock.unlock();
            LOGGER.debug("Unlocked client {}", (Object)this.client);
        }
    }

    public String toString() {
        return "LockedQuestDbClient{lock=" + String.valueOf(this.lock) + ", lockAttemptTime=" + String.valueOf(this.lockAttemptDuration) + ", client=" + String.valueOf(this.client) + "}";
    }
}

