/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.embedded;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlCompilerFactoryImpl;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.mp.SCSequence;
import io.questdb.mp.TimeoutBlockingWaitStrategy;
import io.questdb.mp.WaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.nifi.questdb.Client;
import org.apache.nifi.questdb.DatabaseException;
import org.apache.nifi.questdb.InsertRowDataSource;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.embedded.ClientDisconnectedException;
import org.apache.nifi.questdb.embedded.CursorBasedQueryRowContext;
import org.apache.nifi.questdb.embedded.SqlExecutionContextFactory;
import org.apache.nifi.questdb.embedded.TableWriterBasedInsertRowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EmbeddedClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedClient.class);
    private final Supplier<CairoEngine> engine;
    private final AtomicBoolean disconnected = new AtomicBoolean(false);

    EmbeddedClient(Supplier<CairoEngine> engine) {
        this.engine = engine;
    }

    @Override
    public void execute(String query) throws DatabaseException {
        this.checkConnectionState();
        try (SqlCompiler compiler = this.getCompiler();){
            CompiledQuery compile = compiler.compile((CharSequence)query, this.getSqlExecutionContext());
            compile.execute(new SCSequence((WaitStrategy)new TimeoutBlockingWaitStrategy(5L, TimeUnit.SECONDS)));
        }
        catch (CairoError | SqlException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void insert(String tableName, InsertRowDataSource rowDataSource) throws DatabaseException {
        this.checkConnectionState();
        if (!rowDataSource.hasNextToInsert()) {
            LOGGER.debug("No rows to insert into {}", (Object)tableName);
            return;
        }
        TableToken tableToken = this.engine.get().getTableTokenIfExists((CharSequence)tableName);
        if (tableToken == null) {
            throw new DatabaseException(String.format("Table Token for table [%s] not found", tableName));
        }
        try (TableWriter tableWriter = this.engine.get().getWriter(tableToken, "adding rows");){
            TableWriterBasedInsertRowContext context = new TableWriterBasedInsertRowContext(tableWriter);
            while (rowDataSource.hasNextToInsert()) {
                context.addRow(rowDataSource);
            }
            LOGGER.debug("Committing {} rows", (Object)tableWriter.getRowCount());
            tableWriter.commit();
        }
        catch (CairoError | Exception e) {
            throw new DatabaseException(e);
        }
        finally {
            this.engine.get().releaseInactive();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T query(String query, QueryResultProcessor<T> rowProcessor) throws DatabaseException {
        CompiledQuery compiledQuery;
        this.checkConnectionState();
        try (SqlCompiler compiler = this.getCompiler();){
            compiledQuery = compiler.compile((CharSequence)query, this.getSqlExecutionContext());
        }
        catch (CairoError | SqlException e) {
            throw new DatabaseException(e);
        }
        try (RecordCursorFactory factory = compiledQuery.getRecordCursorFactory();){
            T t;
            block24: {
                RecordCursor cursor = factory.getCursor(this.getSqlExecutionContext());
                try {
                    CursorBasedQueryRowContext rowContext = new CursorBasedQueryRowContext(cursor);
                    while (rowContext.hasNext()) {
                        rowContext.moveToNext();
                        rowProcessor.processRow(rowContext);
                    }
                    t = rowProcessor.getResult();
                    if (cursor == null) break block24;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cursor.close();
            }
            return t;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void disconnect() throws DatabaseException {
        this.checkConnectionState();
        this.disconnected.set(true);
        LOGGER.info("Client disconnected");
    }

    private void checkConnectionState() throws DatabaseException {
        if (this.disconnected.get()) {
            throw new ClientDisconnectedException("The client is already disconnected");
        }
    }

    private SqlCompiler getCompiler() {
        return SqlCompilerFactoryImpl.INSTANCE.getInstance(this.engine.get());
    }

    private SqlExecutionContext getSqlExecutionContext() {
        return SqlExecutionContextFactory.getInstance(this.engine.get());
    }
}

