/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.python.processor;

import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.nifi.annotation.behavior.DefaultRunDuration;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.python.processor.FlowFileSource;
import org.apache.nifi.python.processor.FlowFileSourceResult;
import org.apache.nifi.python.processor.PythonProcessorBridge;
import org.apache.nifi.python.processor.PythonProcessorProxy;
import org.apache.nifi.scheduling.SchedulingStrategy;
import py4j.Py4JNetworkException;

@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@SupportsBatching(defaultDuration=DefaultRunDuration.NO_BATCHING)
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class FlowFileSourceProxy
extends PythonProcessorProxy<FlowFileSource> {
    protected static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles created by this processor can be routed to this relationship.").build();
    private static final Set<Relationship> implicitRelationships = Set.of(REL_SUCCESS);

    public FlowFileSourceProxy(String processorType, Supplier<PythonProcessorBridge> bridgeFactory, boolean initialize) {
        super(processorType, bridgeFactory, initialize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFileSourceResult result;
        try {
            result = ((FlowFileSource)this.getTransform()).createFlowFile();
            if (result == null) {
                return;
            }
        }
        catch (Py4JNetworkException e) {
            throw new ProcessException("Failed to communicate with Python Process", (Throwable)e);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to create FlowFile", (Throwable)e);
            return;
        }
        try {
            String relationshipName = result.getRelationship();
            Relationship relationship = new Relationship.Builder().name(relationshipName).build();
            Map<String, String> attributes = result.getAttributes();
            byte[] contents = result.getContents();
            FlowFile output = this.createFlowFile(session, attributes, contents);
            if (REL_SUCCESS.getName().equals(relationshipName)) {
                session.transfer(output, REL_SUCCESS);
            } else {
                session.transfer(output, relationship);
            }
        }
        finally {
            result.free();
        }
    }

    protected FlowFile createFlowFile(ProcessSession session, Map<String, String> attributes, byte[] contents) {
        FlowFile flowFile = session.create();
        if (attributes != null) {
            flowFile = session.putAllAttributes(flowFile, attributes);
        }
        if (contents != null) {
            flowFile = session.write(flowFile, out -> out.write(contents));
        }
        return flowFile;
    }

    @Override
    protected Set<Relationship> getImplicitRelationships() {
        return implicitRelationships;
    }
}

