/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.pattern;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.pattern.DiscontinuedException;
import org.apache.nifi.processor.util.pattern.PartialFunctions;
import org.apache.nifi.processor.util.pattern.RoutingResult;

public class Put<FC, C extends AutoCloseable> {
    protected PartialFunctions.InitConnection<FC, C> initConnection;
    protected PartialFunctions.FetchFlowFiles<FC> fetchFlowFiles = PartialFunctions.fetchSingleFlowFile();
    protected PutFlowFile<FC, C> putFlowFile;
    protected PartialFunctions.TransferFlowFiles<FC> transferFlowFiles = PartialFunctions.transferRoutedFlowFiles();
    protected PartialFunctions.AdjustRoute<FC> adjustRoute;
    protected PartialFunctions.OnCompleted<FC, C> onCompleted;
    protected PartialFunctions.OnFailed<FC, C> onFailed;
    protected PartialFunctions.Cleanup<FC, C> cleanup;
    protected PartialFunctions.AdjustFailed adjustFailed;
    protected ComponentLog logger;

    protected void putFlowFiles(ProcessContext context, ProcessSession session, FC functionContext, C connection, List<FlowFile> flowFiles, RoutingResult result) throws ProcessException {
        for (FlowFile flowFile : flowFiles) {
            this.putFlowFile.apply(context, session, functionContext, connection, flowFile, result);
        }
    }

    protected void validateCompositePattern() {
        Objects.requireNonNull(this.initConnection, "InitConnection function is required.");
        Objects.requireNonNull(this.putFlowFile, "PutFlowFile function is required.");
        Objects.requireNonNull(this.transferFlowFiles, "TransferFlowFiles function is required.");
    }

    public void onTrigger(ProcessContext context, ProcessSession session, FC functionContext) throws ProcessException {
        this.validateCompositePattern();
        RoutingResult result = new RoutingResult();
        List<FlowFile> flowFiles = this.fetchFlowFiles.apply(context, session, functionContext, result);
        result.getRoutedFlowFiles().forEach((relationship, routedFlowFiles) -> session.transfer((Collection)routedFlowFiles, relationship));
        if (flowFiles == null || flowFiles.isEmpty()) {
            this.logger.debug("No incoming FlowFiles.");
            return;
        }
        try (AutoCloseable connection = (AutoCloseable)this.initConnection.apply(context, session, functionContext, flowFiles);){
            try {
                try {
                    this.putFlowFiles(context, session, functionContext, connection, flowFiles, result);
                }
                catch (DiscontinuedException discontinuedException) {
                    // empty catch block
                }
                if (this.adjustRoute != null) {
                    this.adjustRoute.apply(context, session, functionContext, result);
                }
                List transferredFlowFiles = result.getRoutedFlowFiles().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                List<FlowFile> unprocessedFlowFiles = flowFiles.stream().filter(flowFile -> !transferredFlowFiles.contains(flowFile)).collect(Collectors.toList());
                result.routeTo(unprocessedFlowFiles, Relationship.SELF);
                boolean failed = false;
                if (this.adjustFailed != null) {
                    failed = this.adjustFailed.apply(context, result);
                }
                if (failed && this.onFailed != null) {
                    this.onFailed.apply(context, session, functionContext, connection, null);
                }
                if (!failed && this.onCompleted != null) {
                    this.onCompleted.apply(context, session, functionContext, connection);
                }
                this.transferFlowFiles.apply(context, session, functionContext, result);
            }
            catch (Exception e) {
                if (this.onFailed != null) {
                    this.onFailed.apply(context, session, functionContext, connection, e);
                }
                throw e;
            }
            finally {
                if (this.cleanup != null) {
                    this.cleanup.apply(context, session, functionContext, connection);
                }
            }
        }
        catch (ProcessException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = String.format("Failed to execute due to %s", e);
            this.logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public void fetchFlowFiles(PartialFunctions.FetchFlowFiles<FC> f) {
        this.fetchFlowFiles = f;
    }

    public void initConnection(PartialFunctions.InitConnection<FC, C> f) {
        this.initConnection = f;
    }

    public void putFlowFile(PutFlowFile<FC, C> f) {
        this.putFlowFile = f;
    }

    public void adjustRoute(PartialFunctions.AdjustRoute<FC> f) {
        this.adjustRoute = f;
    }

    public void adjustFailed(PartialFunctions.AdjustFailed f) {
        this.adjustFailed = f;
    }

    public void transferFlowFiles(PartialFunctions.TransferFlowFiles<FC> f) {
        this.transferFlowFiles = f;
    }

    public void onCompleted(PartialFunctions.OnCompleted<FC, C> f) {
        this.onCompleted = f;
    }

    public void onFailed(PartialFunctions.OnFailed<FC, C> f) {
        this.onFailed = f;
    }

    public void cleanup(PartialFunctions.Cleanup<FC, C> f) {
        this.cleanup = f;
    }

    public void setLogger(ComponentLog logger) {
        this.logger = logger;
    }

    @FunctionalInterface
    public static interface PutFlowFile<FC, C> {
        public void apply(ProcessContext var1, ProcessSession var2, FC var3, C var4, FlowFile var5, RoutingResult var6) throws ProcessException;
    }
}

