/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.pattern;

public enum ErrorTypes {
    PersistentFailure(Destination.ProcessException, Penalty.Yield),
    UnknownFailure(Destination.ProcessException, Penalty.None),
    InvalidInput(Destination.Failure, Penalty.None),
    TemporalFailure(Destination.Retry, Penalty.Yield),
    TemporalInputFailure(Destination.Retry, Penalty.Penalize),
    Defer(Destination.Self, Penalty.Penalize);

    private final Destination destination;
    private final Penalty penalty;

    private ErrorTypes(Destination destination, Penalty penalty) {
        this.destination = destination;
        this.penalty = penalty;
    }

    public Result result() {
        return new Result(this.destination, this.penalty);
    }

    public Destination destination() {
        return this.destination;
    }

    public Penalty penalty() {
        return this.penalty;
    }

    public static enum Destination {
        ProcessException,
        Failure,
        Retry,
        Self;

    }

    public static enum Penalty {
        Yield,
        Penalize,
        None;

    }

    public static class Result {
        private final Destination destination;
        private final Penalty penalty;

        public Result(Destination destination, Penalty penalty) {
            this.destination = destination;
            this.penalty = penalty;
        }

        public Destination destination() {
            return this.destination;
        }

        public Penalty penalty() {
            return this.penalty;
        }

        public String toString() {
            return "Result{destination=" + String.valueOf((Object)this.destination) + ", penalty=" + String.valueOf((Object)this.penalty) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            if (this.destination != result.destination) {
                return false;
            }
            return this.penalty == result.penalty;
        }

        public int hashCode() {
            int result = this.destination != null ? this.destination.hashCode() : 0;
            result = 31 * result + (this.penalty != null ? this.penalty.hashCode() : 0);
            return result;
        }
    }
}

