/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.protobuf;

import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.services.protobuf.ProtobufRecordReader;
import org.apache.nifi.services.protobuf.StandardProtobufReader;
import org.apache.nifi.services.protobuf.schema.ProtoSchemaStrategy;
import org.apache.nifi.services.protobuf.validation.ProtoValidationResource;

@Tags(value={"protobuf", "record", "reader", "parser"})
@CapabilityDescription(value="Parses a Protocol Buffers message from binary format.")
@SeeAlso(value={StandardProtobufReader.class})
public class ProtobufReader
extends SchemaRegistryService
implements RecordReaderFactory {
    private static final String ANY_PROTO = "google/protobuf/any.proto";
    private static final String DURATION_PROTO = "google/protobuf/duration.proto";
    private static final String EMPTY_PROTO = "google/protobuf/empty.proto";
    private static final String STRUCT_PROTO = "google/protobuf/struct.proto";
    private static final String TIMESTAMP_PROTO = "google/protobuf/timestamp.proto";
    private static final String WRAPPERS_PROTO = "google/protobuf/wrappers.proto";
    private static final AllowableValue GENERATE_FROM_PROTO_FILE = new AllowableValue("generate-from-proto-file", "Generate from Proto file", "The record schema is generated from the provided proto file");
    private volatile String messageType;
    private volatile Schema protoSchema;
    private final AtomicReference<ProtoValidationResource> validationResourceHolder = new AtomicReference();
    public static final PropertyDescriptor PROTOBUF_DIRECTORY = new PropertyDescriptor.Builder().name("Proto Directory").description("Directory containing Protocol Buffers message definition (.proto) file(s).").required(true).addValidator(StandardValidators.createDirectoryExistsValidator((boolean)true, (boolean)false)).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor MESSAGE_TYPE = new PropertyDescriptor.Builder().name("Message Type").description("Fully qualified name of the Protocol Buffers message type including its package (eg. mypackage.MyMessage). The .proto files configured in '" + PROTOBUF_DIRECTORY.getDisplayName() + "' must contain the definition of this message type.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(PROTOBUF_DIRECTORY);
        properties.add(MESSAGE_TYPE);
        return properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        Schema protoSchema;
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        String protoDirectory = validationContext.getProperty(PROTOBUF_DIRECTORY).evaluateAttributeExpressions().getValue();
        String messageType = validationContext.getProperty(MESSAGE_TYPE).evaluateAttributeExpressions().getValue();
        if (protoDirectory != null && messageType != null && (protoSchema = this.getSchemaForValidation(protoDirectory)).getType(messageType) == null) {
            problems.add(new ValidationResult.Builder().subject(MESSAGE_TYPE.getDisplayName()).valid(false).explanation(String.format("'%s' message type cannot be found in the provided proto files.", messageType)).build());
        }
        return problems;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        String protoDirectory = context.getProperty(PROTOBUF_DIRECTORY).evaluateAttributeExpressions().getValue();
        this.messageType = context.getProperty(MESSAGE_TYPE).evaluateAttributeExpressions().getValue();
        this.protoSchema = this.loadProtoSchema(protoDirectory);
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String allowableValue, SchemaRegistry schemaRegistry, PropertyContext context) {
        if (allowableValue.equalsIgnoreCase(GENERATE_FROM_PROTO_FILE.getValue())) {
            return new ProtoSchemaStrategy(this.messageType, this.protoSchema);
        }
        return SchemaAccessUtils.getSchemaAccessStrategy((String)allowableValue, (SchemaRegistry)schemaRegistry, (PropertyContext)context);
    }

    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>(super.getSchemaAccessStrategyValues());
        allowableValues.add(GENERATE_FROM_PROTO_FILE);
        return allowableValues;
    }

    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return GENERATE_FROM_PROTO_FILE;
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws IOException, SchemaNotFoundException {
        return new ProtobufRecordReader(this.protoSchema, this.messageType, in, this.getSchema(variables, in, null));
    }

    private Schema loadProtoSchema(String protoDirectory) {
        SchemaLoader schemaLoader = new SchemaLoader(FileSystems.getDefault());
        schemaLoader.initRoots(Arrays.asList(Location.get((String)protoDirectory), Location.get((String)"wire-runtime.jar", (String)ANY_PROTO), Location.get((String)"wire-runtime.jar", (String)DURATION_PROTO), Location.get((String)"wire-runtime.jar", (String)EMPTY_PROTO), Location.get((String)"wire-runtime.jar", (String)STRUCT_PROTO), Location.get((String)"wire-runtime.jar", (String)TIMESTAMP_PROTO), Location.get((String)"wire-runtime.jar", (String)WRAPPERS_PROTO)), Collections.emptyList());
        return schemaLoader.loadSchema();
    }

    private Schema getSchemaForValidation(String protoDirectory) {
        ProtoValidationResource validationResource = this.validationResourceHolder.get();
        if (validationResource == null || !protoDirectory.equals(validationResource.getProtoDirectory())) {
            validationResource = new ProtoValidationResource(protoDirectory, this.loadProtoSchema(protoDirectory));
            this.validationResourceHolder.set(validationResource);
        }
        return validationResource.getProtoSchema();
    }
}

