/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.properties.AESSensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESSensitivePropertyProviderFactory
implements SensitivePropertyProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(AESSensitivePropertyProviderFactory.class);
    private String keyHex;

    public AESSensitivePropertyProviderFactory(String keyHex) {
        this.keyHex = keyHex;
    }

    @Override
    public SensitivePropertyProvider getProvider() throws SensitivePropertyProtectionException {
        try {
            if (this.keyHex != null && !StringUtils.isBlank((CharSequence)this.keyHex)) {
                return new AESSensitivePropertyProvider(this.keyHex);
            }
            throw new SensitivePropertyProtectionException("The provider factory cannot generate providers without a key");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            String msg = "Error creating AES Sensitive Property Provider";
            logger.warn(msg, (Throwable)e);
            throw new SensitivePropertyProtectionException(msg, e);
        }
    }

    public String toString() {
        return "SensitivePropertyProviderFactory for creating AESSensitivePropertyProviders";
    }
}

