/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.prometheus.api;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.TransmissionStatus;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.RestrictedSSLContextService;

public class PrometheusMetricsUtil {
    public static final AllowableValue METRICS_STRATEGY_ROOT = new AllowableValue("Root Process Group", "Root Process Group", "Send rollup metrics for the entire root process group");
    public static final AllowableValue METRICS_STRATEGY_PG = new AllowableValue("All Process Groups", "All Process Groups", "Send metrics for each process group");
    public static final AllowableValue METRICS_STRATEGY_COMPONENTS = new AllowableValue("All Components", "All Components", "Send metrics for each component in the system, to include processors, connections, controller services, etc.");
    private static final CollectorRegistry NIFI_REGISTRY = new CollectorRegistry();
    private static final CollectorRegistry JVM_REGISTRY = new CollectorRegistry();
    public static final AllowableValue CLIENT_NONE = new AllowableValue("No Authentication", "No Authentication", "ReportingTask will not authenticate clients. Anyone can communicate with this ReportingTask anonymously");
    public static final AllowableValue CLIENT_WANT = new AllowableValue("Want Authentication", "Want Authentication", "ReportingTask will try to verify the client but if unable to verify will allow the client to communicate anonymously");
    public static final AllowableValue CLIENT_NEED = new AllowableValue("Need Authentication", "Need Authentication", "ReportingTask will reject communications from any client unless the client provides a certificate that is trusted by the TrustStorespecified in the SSL Context Service");
    public static final PropertyDescriptor METRICS_ENDPOINT_PORT = new PropertyDescriptor.Builder().name("prometheus-reporting-task-metrics-endpoint-port").displayName("Prometheus Metrics Endpoint Port").description("The Port where prometheus metrics can be accessed").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("9092").addValidator(StandardValidators.INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor INSTANCE_ID = new PropertyDescriptor.Builder().name("prometheus-reporting-task-instance-id").displayName("Instance ID").description("Id of this NiFi instance to be included in the metrics sent to Prometheus").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("${hostname(true)}").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SSL_CONTEXT = new PropertyDescriptor.Builder().name("prometheus-reporting-task-ssl-context").displayName("SSL Context Service").description("The SSL Context Service to use in order to secure the server. If specified, the server willaccept only HTTPS requests; otherwise, the server will accept only HTTP requests").required(false).identifiesControllerService(RestrictedSSLContextService.class).build();
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("prometheus-reporting-task-client-auth").displayName("Client Authentication").description("Specifies whether or not the Reporting Task should authenticate clients. This value is ignored if the <SSL Context Service> Property is not specified or the SSL Context provided uses only a KeyStore and not a TrustStore.").required(true).allowableValues(new AllowableValue[]{CLIENT_NONE, CLIENT_WANT, CLIENT_NEED}).defaultValue(CLIENT_NONE.getValue()).build();
    private static final Gauge AMOUNT_FLOWFILES_SENT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_flowfiles_sent")).help("Total number of FlowFiles sent by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_FLOWFILES_TRANSFERRED = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_flowfiles_transferred")).help("Total number of FlowFiles transferred by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_FLOWFILES_RECEIVED = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_flowfiles_received")).help("Total number of FlowFiles received by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_FLOWFILES_REMOVED = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_flowfiles_removed")).help("Total number of FlowFiles removed by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_BYTES_SENT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_bytes_sent")).help("Total number of bytes sent by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_BYTES_READ = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_bytes_read")).help("Total number of bytes read by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_BYTES_WRITTEN = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_bytes_written")).help("Total number of bytes written by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_BYTES_RECEIVED = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_bytes_received")).help("Total number of bytes received by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_BYTES_TRANSFERRED = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_bytes_transferred")).help("Total number of Bytes transferred by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_THREADS_TOTAL_ACTIVE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_threads_active")).help("Total number of threads active for the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_THREADS_TOTAL_TERMINATED = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_threads_terminated")).help("Total number of threads terminated for the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id"})).register(NIFI_REGISTRY);
    private static final Gauge SIZE_CONTENT_OUTPUT_TOTAL = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_size_content_output_total")).help("Total size of content output by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge SIZE_CONTENT_INPUT_TOTAL = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_size_content_input_total")).help("Total size of content input by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge SIZE_CONTENT_QUEUED_TOTAL = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_size_content_queued_total")).help("Total size of content queued in the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_ITEMS_OUTPUT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_items_output")).help("Total number of items output by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_ITEMS_INPUT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_items_input")).help("Total number of items input by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge AMOUNT_ITEMS_QUEUED = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_amount_items_queued")).help("Total number of items queued by the component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge PROCESSOR_COUNTERS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_processor_counters")).help("Counters exposed by NiFi Processors")).labelNames(new String[]{"processor_name", "counter_name", "processor_id", "instance"})).register(NIFI_REGISTRY);
    private static final Gauge BACKPRESSURE_BYTES_THRESHOLD = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_backpressure_bytes_threshold")).help("The number of bytes that can be queued before backpressure is applied")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge BACKPRESSURE_OBJECT_THRESHOLD = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_backpressure_object_threshold")).help("The number of flow files that can be queued before backpressure is applied")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge IS_BACKPRESSURE_ENABLED = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_backpressure_enabled")).help("Whether backpressure has been applied for this component. Values are 0 or 1")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge IS_TRANSMITTING = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_transmitting")).help("Whether this component is transmitting data. Values are 0 or 1")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "run_status"})).register(NIFI_REGISTRY);
    private static final Gauge ACTIVE_REMOTE_PORT_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_active_remote_port_count")).help("The number of active remote ports associated with this component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge INACTIVE_REMOTE_PORT_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_inactive_remote_port_count")).help("The number of inactive remote ports associated with this component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge AVERAGE_LINEAGE_DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_average_lineage_duration")).help("The average lineage duration (in milliseconds) for all flow file processed by this component")).labelNames(new String[]{"instance", "component_type", "component_name", "component_id", "parent_id", "source_id", "source_name", "destination_id", "destination_name"})).register(NIFI_REGISTRY);
    private static final Gauge JVM_HEAP_USED = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_jvm_heap_used")).help("NiFi JVM heap used")).labelNames(new String[]{"instance"})).register(JVM_REGISTRY);
    private static final Gauge JVM_HEAP_USAGE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_jvm_heap_usage")).help("NiFi JVM heap usage")).labelNames(new String[]{"instance"})).register(JVM_REGISTRY);
    private static final Gauge JVM_HEAP_NON_USAGE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_jvm_heap_non_usage")).help("NiFi JVM heap non usage")).labelNames(new String[]{"instance"})).register(JVM_REGISTRY);
    private static final Gauge JVM_THREAD_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_jvm_thread_count")).help("NiFi JVM thread count")).labelNames(new String[]{"instance"})).register(JVM_REGISTRY);
    private static final Gauge JVM_DAEMON_THREAD_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_jvm_daemon_thread_count")).help("NiFi JVM daemon thread count")).labelNames(new String[]{"instance"})).register(JVM_REGISTRY);
    private static final Gauge JVM_UPTIME = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_jvm_uptime")).help("NiFi JVM uptime")).labelNames(new String[]{"instance"})).register(JVM_REGISTRY);
    private static final Gauge JVM_FILE_DESCRIPTOR_USAGE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_jvm_file_descriptor_usage")).help("NiFi JVM file descriptor usage")).labelNames(new String[]{"instance"})).register(JVM_REGISTRY);
    private static final Gauge JVM_GC_RUNS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_jvm_gc_runs")).help("NiFi JVM GC number of runs")).labelNames(new String[]{"instance", "gc_name"})).register(JVM_REGISTRY);
    private static final Gauge JVM_GC_TIME = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("nifi_jvm_gc_time")).help("NiFi JVM GC time in milliseconds")).labelNames(new String[]{"instance", "gc_name"})).register(JVM_REGISTRY);

    public static CollectorRegistry createNifiMetrics(ProcessGroupStatus status, String instanceId, String parentPGId, String componentType, String metricsStrategy) {
        String componentId = status.getId();
        String componentName = status.getName();
        if ("RootProcessGroup".equals(componentType)) {
            try {
                for (Field field : PrometheusMetricsUtil.class.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !(field.get(null) instanceof SimpleCollector)) continue;
                    SimpleCollector sc = (SimpleCollector)field.get(null);
                    sc.clear();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        ((Gauge.Child)AMOUNT_FLOWFILES_SENT.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId})).set((double)status.getFlowFilesSent());
        ((Gauge.Child)AMOUNT_FLOWFILES_TRANSFERRED.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId})).set((double)status.getFlowFilesTransferred());
        ((Gauge.Child)AMOUNT_FLOWFILES_RECEIVED.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId})).set((double)status.getFlowFilesReceived());
        ((Gauge.Child)AMOUNT_BYTES_SENT.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId})).set((double)status.getBytesSent());
        ((Gauge.Child)AMOUNT_BYTES_READ.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId})).set((double)status.getBytesRead().longValue());
        ((Gauge.Child)AMOUNT_BYTES_WRITTEN.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId})).set((double)status.getBytesWritten().longValue());
        ((Gauge.Child)AMOUNT_BYTES_RECEIVED.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId})).set((double)status.getBytesReceived());
        ((Gauge.Child)AMOUNT_BYTES_TRANSFERRED.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId})).set((double)status.getBytesTransferred());
        ((Gauge.Child)SIZE_CONTENT_OUTPUT_TOTAL.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""})).set((double)status.getOutputContentSize().longValue());
        ((Gauge.Child)SIZE_CONTENT_INPUT_TOTAL.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""})).set((double)status.getInputContentSize().longValue());
        ((Gauge.Child)SIZE_CONTENT_QUEUED_TOTAL.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""})).set((double)status.getQueuedContentSize().longValue());
        ((Gauge.Child)AMOUNT_ITEMS_OUTPUT.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""})).set((double)status.getOutputCount().intValue());
        ((Gauge.Child)AMOUNT_ITEMS_INPUT.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""})).set((double)status.getInputCount().intValue());
        ((Gauge.Child)AMOUNT_ITEMS_QUEUED.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""})).set((double)status.getQueuedCount().intValue());
        ((Gauge.Child)AMOUNT_THREADS_TOTAL_ACTIVE.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId})).set(status.getActiveThreadCount() == null ? 0.0 : (double)status.getActiveThreadCount().intValue());
        ((Gauge.Child)AMOUNT_THREADS_TOTAL_TERMINATED.labels(new String[]{instanceId, componentType, componentName, componentId, parentPGId})).set(status.getTerminatedThreadCount() == null ? 0.0 : (double)status.getTerminatedThreadCount().intValue());
        if (METRICS_STRATEGY_PG.getValue().equals(metricsStrategy) || METRICS_STRATEGY_COMPONENTS.getValue().equals(metricsStrategy)) {
            status.getProcessGroupStatus().forEach(childGroupStatus -> PrometheusMetricsUtil.createNifiMetrics(childGroupStatus, instanceId, componentId, "ProcessGroup", metricsStrategy));
        }
        if (METRICS_STRATEGY_COMPONENTS.getValue().equals(metricsStrategy)) {
            Boolean isTransmitting;
            String portComponentType;
            String parentId;
            String portComponentName;
            for (ProcessorStatus processorStatus : status.getProcessorStatus()) {
                Map counters = processorStatus.getCounters();
                if (counters != null) {
                    counters.entrySet().stream().forEach(entry -> ((Gauge.Child)PROCESSOR_COUNTERS.labels(new String[]{processorStatus.getName(), (String)entry.getKey(), processorStatus.getId(), instanceId})).set((double)((Long)entry.getValue()).longValue()));
                }
                String procComponentType = "Processor";
                String procComponentId = processorStatus.getId();
                String procComponentName = processorStatus.getName();
                String parentId2 = processorStatus.getGroupId();
                ((Gauge.Child)AMOUNT_FLOWFILES_SENT.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId})).set((double)processorStatus.getFlowFilesSent());
                ((Gauge.Child)AMOUNT_FLOWFILES_RECEIVED.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId})).set((double)processorStatus.getFlowFilesReceived());
                ((Gauge.Child)AMOUNT_FLOWFILES_REMOVED.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId})).set((double)processorStatus.getFlowFilesRemoved());
                ((Gauge.Child)AMOUNT_BYTES_SENT.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId})).set((double)processorStatus.getBytesSent());
                ((Gauge.Child)AMOUNT_BYTES_READ.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId})).set((double)processorStatus.getBytesRead());
                ((Gauge.Child)AMOUNT_BYTES_WRITTEN.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId})).set((double)processorStatus.getBytesWritten());
                ((Gauge.Child)AMOUNT_BYTES_RECEIVED.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId})).set((double)processorStatus.getBytesReceived());
                ((Gauge.Child)SIZE_CONTENT_OUTPUT_TOTAL.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId, "", "", "", ""})).set((double)processorStatus.getOutputBytes());
                ((Gauge.Child)SIZE_CONTENT_INPUT_TOTAL.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId, "", "", "", ""})).set((double)processorStatus.getInputBytes());
                ((Gauge.Child)AMOUNT_ITEMS_OUTPUT.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId, "", "", "", ""})).set((double)processorStatus.getOutputCount());
                ((Gauge.Child)AMOUNT_ITEMS_INPUT.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId, "", "", "", ""})).set((double)processorStatus.getInputCount());
                ((Gauge.Child)AVERAGE_LINEAGE_DURATION.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentPGId, "", "", "", ""})).set((double)processorStatus.getAverageLineageDuration());
                ((Gauge.Child)AMOUNT_THREADS_TOTAL_ACTIVE.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2})).set(status.getActiveThreadCount() == null ? 0.0 : (double)status.getActiveThreadCount().intValue());
                ((Gauge.Child)AMOUNT_THREADS_TOTAL_TERMINATED.labels(new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2})).set(status.getTerminatedThreadCount() == null ? 0.0 : (double)status.getTerminatedThreadCount().intValue());
            }
            for (ConnectionStatus connectionStatus : status.getConnectionStatus()) {
                String connComponentId = connectionStatus.getId();
                String connComponentName = connectionStatus.getName();
                String sourceId = connectionStatus.getSourceId();
                String sourceName = connectionStatus.getSourceName();
                String destinationId = connectionStatus.getDestinationId();
                String destinationName = connectionStatus.getDestinationName();
                String parentId3 = connectionStatus.getGroupId();
                String connComponentType = "Connection";
                ((Gauge.Child)SIZE_CONTENT_OUTPUT_TOTAL.labels(new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName})).set((double)connectionStatus.getOutputBytes());
                ((Gauge.Child)SIZE_CONTENT_INPUT_TOTAL.labels(new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName})).set((double)connectionStatus.getInputBytes());
                ((Gauge.Child)SIZE_CONTENT_QUEUED_TOTAL.labels(new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName})).set((double)connectionStatus.getQueuedBytes());
                ((Gauge.Child)AMOUNT_ITEMS_OUTPUT.labels(new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName})).set((double)connectionStatus.getOutputCount());
                ((Gauge.Child)AMOUNT_ITEMS_INPUT.labels(new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName})).set((double)connectionStatus.getInputCount());
                ((Gauge.Child)AMOUNT_ITEMS_QUEUED.labels(new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName})).set((double)connectionStatus.getQueuedCount());
                ((Gauge.Child)BACKPRESSURE_BYTES_THRESHOLD.labels(new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName})).set((double)connectionStatus.getBackPressureBytesThreshold());
                ((Gauge.Child)BACKPRESSURE_OBJECT_THRESHOLD.labels(new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName})).set((double)connectionStatus.getBackPressureObjectThreshold());
                boolean isBackpressureEnabled = connectionStatus.getBackPressureObjectThreshold() > 0L && connectionStatus.getBackPressureObjectThreshold() <= (long)connectionStatus.getQueuedCount() || connectionStatus.getBackPressureBytesThreshold() > 0L && connectionStatus.getBackPressureBytesThreshold() <= connectionStatus.getMaxQueuedBytes();
                ((Gauge.Child)IS_BACKPRESSURE_ENABLED.labels(new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName})).set(isBackpressureEnabled ? 1.0 : 0.0);
            }
            for (PortStatus portStatus : status.getInputPortStatus()) {
                String portComponentId = portStatus.getId();
                portComponentName = portStatus.getName();
                parentId = portStatus.getGroupId();
                portComponentType = "InputPort";
                ((Gauge.Child)AMOUNT_FLOWFILES_SENT.labels(new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getFlowFilesSent());
                ((Gauge.Child)AMOUNT_FLOWFILES_RECEIVED.labels(new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getFlowFilesReceived());
                ((Gauge.Child)AMOUNT_BYTES_SENT.labels(new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getBytesSent());
                ((Gauge.Child)AMOUNT_BYTES_READ.labels(new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getInputBytes());
                ((Gauge.Child)AMOUNT_BYTES_WRITTEN.labels(new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getOutputBytes());
                ((Gauge.Child)AMOUNT_BYTES_RECEIVED.labels(new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getBytesReceived());
                ((Gauge.Child)AMOUNT_ITEMS_OUTPUT.labels(new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId, "", "", "", ""})).set((double)portStatus.getOutputCount());
                ((Gauge.Child)AMOUNT_ITEMS_INPUT.labels(new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId, "", "", "", ""})).set((double)portStatus.getInputCount());
                isTransmitting = portStatus.isTransmitting();
                ((Gauge.Child)IS_TRANSMITTING.labels(new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId, portStatus.getRunStatus().name()})).set(isTransmitting == null ? 0.0 : (double)(isTransmitting != false ? 1 : 0));
                ((Gauge.Child)AMOUNT_THREADS_TOTAL_ACTIVE.labels(new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getActiveThreadCount().intValue());
            }
            for (PortStatus portStatus : status.getOutputPortStatus()) {
                String portComponentId = portStatus.getId();
                portComponentName = portStatus.getName();
                parentId = portStatus.getGroupId();
                portComponentType = "OutputPort";
                ((Gauge.Child)AMOUNT_FLOWFILES_SENT.labels(new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getFlowFilesSent());
                ((Gauge.Child)AMOUNT_FLOWFILES_RECEIVED.labels(new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getFlowFilesReceived());
                ((Gauge.Child)AMOUNT_BYTES_SENT.labels(new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getBytesSent());
                ((Gauge.Child)AMOUNT_BYTES_READ.labels(new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getInputBytes());
                ((Gauge.Child)AMOUNT_BYTES_WRITTEN.labels(new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getOutputBytes());
                ((Gauge.Child)AMOUNT_BYTES_RECEIVED.labels(new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getBytesReceived());
                ((Gauge.Child)AMOUNT_ITEMS_OUTPUT.labels(new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId, "", "", "", ""})).set((double)portStatus.getOutputCount());
                ((Gauge.Child)AMOUNT_ITEMS_INPUT.labels(new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId, "", "", "", ""})).set((double)portStatus.getInputCount());
                isTransmitting = portStatus.isTransmitting();
                ((Gauge.Child)IS_TRANSMITTING.labels(new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId, portStatus.getRunStatus().name()})).set(isTransmitting == null ? 0.0 : (double)(isTransmitting != false ? 1 : 0));
                ((Gauge.Child)AMOUNT_THREADS_TOTAL_ACTIVE.labels(new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId})).set((double)portStatus.getActiveThreadCount().intValue());
            }
            for (RemoteProcessGroupStatus remoteProcessGroupStatus : status.getRemoteProcessGroupStatus()) {
                String rpgComponentId = remoteProcessGroupStatus.getId();
                String rpgComponentName = remoteProcessGroupStatus.getName();
                parentId = remoteProcessGroupStatus.getGroupId();
                String rpgComponentType = "RemoteProcessGroup";
                ((Gauge.Child)AMOUNT_BYTES_WRITTEN.labels(new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId})).set((double)remoteProcessGroupStatus.getSentContentSize().longValue());
                ((Gauge.Child)AMOUNT_BYTES_RECEIVED.labels(new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId})).set((double)remoteProcessGroupStatus.getReceivedContentSize().longValue());
                ((Gauge.Child)AMOUNT_ITEMS_OUTPUT.labels(new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, "", "", "", ""})).set((double)remoteProcessGroupStatus.getSentCount().intValue());
                ((Gauge.Child)AMOUNT_ITEMS_INPUT.labels(new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, "", "", "", ""})).set((double)remoteProcessGroupStatus.getReceivedCount().intValue());
                ((Gauge.Child)ACTIVE_REMOTE_PORT_COUNT.labels(new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, "", "", "", ""})).set((double)remoteProcessGroupStatus.getActiveRemotePortCount().intValue());
                ((Gauge.Child)INACTIVE_REMOTE_PORT_COUNT.labels(new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, "", "", "", ""})).set((double)remoteProcessGroupStatus.getInactiveRemotePortCount().intValue());
                ((Gauge.Child)AVERAGE_LINEAGE_DURATION.labels(new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, "", "", "", ""})).set((double)remoteProcessGroupStatus.getAverageLineageDuration());
                ((Gauge.Child)IS_TRANSMITTING.labels(new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, remoteProcessGroupStatus.getTransmissionStatus().name()})).set(TransmissionStatus.Transmitting.equals((Object)remoteProcessGroupStatus.getTransmissionStatus()) ? 1.0 : 0.0);
                ((Gauge.Child)AMOUNT_THREADS_TOTAL_ACTIVE.labels(new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId})).set((double)remoteProcessGroupStatus.getActiveThreadCount().intValue());
            }
        }
        return NIFI_REGISTRY;
    }

    public static CollectorRegistry createJvmMetrics(JvmMetrics jvmMetrics, String instanceId) {
        ((Gauge.Child)JVM_HEAP_USED.labels(new String[]{instanceId})).set(jvmMetrics.heapUsed(DataUnit.B));
        ((Gauge.Child)JVM_HEAP_USAGE.labels(new String[]{instanceId})).set(jvmMetrics.heapUsage());
        ((Gauge.Child)JVM_HEAP_NON_USAGE.labels(new String[]{instanceId})).set(jvmMetrics.nonHeapUsage());
        ((Gauge.Child)JVM_THREAD_COUNT.labels(new String[]{instanceId})).set((double)jvmMetrics.threadCount());
        ((Gauge.Child)JVM_DAEMON_THREAD_COUNT.labels(new String[]{instanceId})).set((double)jvmMetrics.daemonThreadCount());
        ((Gauge.Child)JVM_UPTIME.labels(new String[]{instanceId})).set((double)jvmMetrics.uptime());
        ((Gauge.Child)JVM_FILE_DESCRIPTOR_USAGE.labels(new String[]{instanceId})).set(jvmMetrics.fileDescriptorUsage());
        jvmMetrics.garbageCollectors().forEach((name, stat) -> {
            ((Gauge.Child)JVM_GC_RUNS.labels(new String[]{instanceId, name})).set((double)stat.getRuns());
            ((Gauge.Child)JVM_GC_TIME.labels(new String[]{instanceId, name})).set((double)stat.getTime(TimeUnit.MILLISECONDS));
        });
        return JVM_REGISTRY;
    }
}

