/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.ssl.SSLContextService;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class PrometheusServer {
    private static ComponentLog logger;
    private Server server;
    private ServletContextHandler handler;
    private ReportingContext context;
    private List<Function<ReportingContext, CollectorRegistry>> metricsCollectors;

    public PrometheusServer(InetSocketAddress addr, ComponentLog logger) throws Exception {
        PrometheusServer.logger = logger;
        this.metricsCollectors = Collections.emptyList();
        this.server = new Server(addr);
        this.handler = new ServletContextHandler((HandlerContainer)this.server, "/metrics");
        this.handler.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/");
        this.server.start();
    }

    public PrometheusServer(int addr, SSLContextService sslContextService, ComponentLog logger, boolean needClientAuth, boolean wantClientAuth) throws Exception {
        PrometheusServer.logger = logger;
        this.server = new Server();
        this.handler = new ServletContextHandler((HandlerContainer)this.server, "/metrics");
        this.handler.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/");
        SslContextFactory sslFactory = this.createSslFactory(sslContextService, needClientAuth, wantClientAuth);
        HttpConfiguration httpsConfiguration = new HttpConfiguration();
        httpsConfiguration.setSecureScheme("https");
        httpsConfiguration.setSecurePort(addr);
        httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector https = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslFactory, "http/1.1"), new HttpConnectionFactory(httpsConfiguration)});
        https.setPort(addr);
        this.server.setConnectors(new Connector[]{https});
        this.server.start();
    }

    private SslContextFactory createSslFactory(SSLContextService sslService, boolean needClientAuth, boolean wantClientAuth) {
        SslContextFactory sslFactory = new SslContextFactory();
        sslFactory.setNeedClientAuth(needClientAuth);
        sslFactory.setWantClientAuth(wantClientAuth);
        sslFactory.setProtocol(sslService.getSslAlgorithm());
        if (sslService.isKeyStoreConfigured()) {
            sslFactory.setKeyStorePath(sslService.getKeyStoreFile());
            sslFactory.setKeyStorePassword(sslService.getKeyStorePassword());
            sslFactory.setKeyStoreType(sslService.getKeyStoreType());
        }
        if (sslService.isTrustStoreConfigured()) {
            sslFactory.setTrustStorePath(sslService.getTrustStoreFile());
            sslFactory.setTrustStorePassword(sslService.getTrustStorePassword());
            sslFactory.setTrustStoreType(sslService.getTrustStoreType());
        }
        return sslFactory;
    }

    public Server getServer() {
        return this.server;
    }

    public ReportingContext getReportingContext() {
        return this.context;
    }

    public void setReportingContext(ReportingContext rc) {
        this.context = rc;
    }

    public List<Function<ReportingContext, CollectorRegistry>> getMetricsCollectors() {
        return this.metricsCollectors;
    }

    public void setMetricsCollectors(List<Function<ReportingContext, CollectorRegistry>> metricsCollectors) {
        this.metricsCollectors = metricsCollectors;
    }

    class MetricsServlet
    extends HttpServlet {
        MetricsServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            if (logger.isDebugEnabled()) {
                logger.debug("PrometheusServer Do get called");
            }
            ServletOutputStream response = resp.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response);
            for (Function mc : PrometheusServer.this.metricsCollectors) {
                CollectorRegistry collectorRegistry = (CollectorRegistry)mc.apply(PrometheusServer.this.getReportingContext());
                TextFormat.write004((Writer)osw, (Enumeration)collectorRegistry.metricFamilySamples());
            }
            osw.flush();
            osw.close();
            response.flush();
            response.close();
            resp.setHeader("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
            resp.setStatus(200);
            resp.flushBuffer();
        }
    }
}

