/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.pgp.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;

public class PGPFileUtils {
    private static final String FILE_EXTENSION = ".key";

    public static File getKeyFile(byte[] bytes) throws IOException {
        File encodedFile = File.createTempFile(PGPFileUtils.class.getSimpleName(), FILE_EXTENSION);
        encodedFile.deleteOnExit();
        try (FileOutputStream outputStream = new FileOutputStream(encodedFile);){
            ((OutputStream)outputStream).write(bytes);
            File file = encodedFile;
            return file;
        }
    }

    public static String getArmored(byte[] bytes) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream((OutputStream)outputStream);){
            armoredOutputStream.write(bytes);
        }
        return outputStream.toString();
    }
}

