/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.pgp.service.api.KeyIdentifierConverter;
import org.apache.nifi.pgp.service.api.PGPPublicKeyService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.pgp.DecryptContentPGP;
import org.apache.nifi.processors.pgp.EncryptContentPGP;
import org.apache.nifi.processors.pgp.SignContentPGP;
import org.apache.nifi.processors.pgp.exception.PGPProcessException;
import org.apache.nifi.stream.io.StreamUtils;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"PGP", "GPG", "OpenPGP", "Encryption", "Signing", "RFC 4880"})
@CapabilityDescription(value="Verify signatures using OpenPGP Public Keys")
@SeeAlso(value={DecryptContentPGP.class, EncryptContentPGP.class, SignContentPGP.class})
@WritesAttributes(value={@WritesAttribute(attribute="pgp.literal.data.filename", description="Filename from Literal Data"), @WritesAttribute(attribute="pgp.literal.data.modified", description="Modified Date Time from Literal Data in milliseconds"), @WritesAttribute(attribute="pgp.signature.created", description="Signature Creation Time in milliseconds"), @WritesAttribute(attribute="pgp.signature.algorithm", description="Signature Algorithm including key and hash algorithm names"), @WritesAttribute(attribute="pgp.signature.hash.algorithm.id", description="Signature Hash Algorithm Identifier"), @WritesAttribute(attribute="pgp.signature.key.algorithm.id", description="Signature Key Algorithm Identifier"), @WritesAttribute(attribute="pgp.signature.key.id", description="Signature Public Key Identifier"), @WritesAttribute(attribute="pgp.signature.type.id", description="Signature Type Identifier"), @WritesAttribute(attribute="pgp.signature.version", description="Signature Version Number")})
public class VerifyContentPGP
extends AbstractProcessor {
    public static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Signature Verification Succeeded").build();
    public static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Signature Verification Failed").build();
    public static final PropertyDescriptor PUBLIC_KEY_SERVICE = new PropertyDescriptor.Builder().name("Public Key Service").description("PGP Public Key Service for verifying signatures with Public Key Encryption").identifiesControllerService(PGPPublicKeyService.class).required(true).build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(SUCCESS, FAILURE);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(PUBLIC_KEY_SERVICE);
    private static final int BUFFER_SIZE = 8192;
    private static final String KEY_ID_UNKNOWN = "UNKNOWN";

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        PGPPublicKeyService publicKeyService = (PGPPublicKeyService)context.getProperty(PUBLIC_KEY_SERVICE).asControllerService(PGPPublicKeyService.class);
        VerifyStreamCallback callback = new VerifyStreamCallback(publicKeyService);
        try {
            flowFile = session.write(flowFile, (StreamCallback)callback);
            flowFile = session.putAllAttributes(flowFile, callback.attributes);
            String keyId = flowFile.getAttribute("pgp.signature.key.id");
            this.getLogger().info("Signature Key ID [{}] Verification Completed {}", new Object[]{keyId, flowFile});
            session.transfer(flowFile, SUCCESS);
        }
        catch (RuntimeException e) {
            flowFile = session.putAllAttributes(flowFile, callback.attributes);
            this.getLogger().error("Processing Failed {}", new Object[]{flowFile, e});
            session.transfer(flowFile, FAILURE);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("public-key-service", PUBLIC_KEY_SERVICE.getName());
    }

    private class VerifyStreamCallback
    implements StreamCallback {
        private final PGPPublicKeyService publicKeyService;
        private final Map<String, String> attributes = new HashMap<String, String>();
        private boolean verified;

        private VerifyStreamCallback(PGPPublicKeyService publicKeyService) {
            this.publicKeyService = publicKeyService;
        }

        public void process(InputStream inputStream, OutputStream outputStream) throws IOException {
            InputStream decoderInputStream = PGPUtil.getDecoderStream((InputStream)inputStream);
            JcaPGPObjectFactory pgpObjectFactory = new JcaPGPObjectFactory(decoderInputStream);
            Iterator objects = pgpObjectFactory.iterator();
            if (objects.hasNext()) {
                this.processObjectFactory(objects, outputStream);
            }
            if (!this.verified) {
                String keyId = this.attributes.getOrDefault("pgp.signature.key.id", VerifyContentPGP.KEY_ID_UNKNOWN);
                throw new PGPProcessException(String.format("Signature Key ID [%s] Verification Failed", keyId));
            }
            VerifyContentPGP.this.getLogger().debug("One-Pass Signature Algorithm [{}] Verified", new Object[]{this.attributes.get("pgp.signature.algorithm")});
        }

        private void processObjectFactory(Iterator<?> objects, OutputStream outputStream) throws IOException {
            PGPOnePassSignature onePassSignature = null;
            while (objects.hasNext()) {
                Object obj;
                Object object = objects.next();
                VerifyContentPGP.this.getLogger().debug("PGP Object Read [{}]", new Object[]{object.getClass().getSimpleName()});
                Objects.requireNonNull(object);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PGPCompressedData.class, PGPOnePassSignatureList.class, PGPLiteralData.class, PGPSignatureList.class}, obj, n)) {
                    case 0: {
                        PGPCompressedData compressedData = (PGPCompressedData)obj;
                        try {
                            JcaPGPObjectFactory compressedObjectFactory = new JcaPGPObjectFactory(compressedData.getDataStream());
                            this.processObjectFactory(compressedObjectFactory.iterator(), outputStream);
                            break;
                        }
                        catch (PGPException e) {
                            throw new PGPProcessException("Read Compressed Data Failed", e);
                        }
                    }
                    case 1: {
                        PGPOnePassSignatureList onePassSignatureList = (PGPOnePassSignatureList)obj;
                        onePassSignature = this.processOnePassSignatures(onePassSignatureList);
                        break;
                    }
                    case 2: {
                        PGPLiteralData literalData = (PGPLiteralData)obj;
                        this.processLiteralData(literalData, outputStream, onePassSignature);
                        break;
                    }
                    case 3: {
                        PGPSignatureList signatureList = (PGPSignatureList)obj;
                        this.processSignatures(signatureList, onePassSignature);
                        break;
                    }
                }
            }
        }

        private PGPOnePassSignature processOnePassSignatures(PGPOnePassSignatureList onePassSignatureList) {
            VerifyContentPGP.this.getLogger().debug("One-Pass Signatures Found [{}]", new Object[]{onePassSignatureList.size()});
            PGPOnePassSignature initializedOnePassSignature = null;
            Iterator onePassSignatures = onePassSignatureList.iterator();
            if (onePassSignatures.hasNext()) {
                PGPOnePassSignature onePassSignature = (PGPOnePassSignature)onePassSignatures.next();
                this.setOnePassSignatureAttributes(onePassSignature);
                String keyId = KeyIdentifierConverter.format((long)onePassSignature.getKeyID());
                Optional optionalPublicKey = this.publicKeyService.findPublicKey(keyId);
                if (optionalPublicKey.isPresent()) {
                    VerifyContentPGP.this.getLogger().debug("One-Pass Signature Key ID [{}] found", new Object[]{keyId});
                    PGPPublicKey publicKey = (PGPPublicKey)optionalPublicKey.get();
                    try {
                        onePassSignature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider(), publicKey);
                        initializedOnePassSignature = onePassSignature;
                    }
                    catch (PGPException e) {
                        throw new PGPProcessException(String.format("One-Pass Signature Key ID [%s] Initialization Failed", keyId), e);
                    }
                } else {
                    VerifyContentPGP.this.getLogger().warn("One-Pass Signature Key ID [{}] not found in Public Key Service", new Object[]{keyId});
                }
            }
            return initializedOnePassSignature;
        }

        private void processLiteralData(PGPLiteralData literalData, OutputStream outputStream, PGPOnePassSignature onePassSignature) throws IOException {
            this.setLiteralDataAttributes(literalData);
            InputStream literalInputStream = literalData.getInputStream();
            if (onePassSignature == null) {
                StreamUtils.copy((InputStream)literalInputStream, (OutputStream)outputStream);
            } else {
                this.processSignedStream(literalInputStream, outputStream, onePassSignature);
            }
        }

        private void processSignatures(PGPSignatureList signatureList, PGPOnePassSignature onePassSignature) {
            VerifyContentPGP.this.getLogger().debug("Signatures Found [{}]", new Object[]{signatureList.size()});
            Iterator signatures = signatureList.iterator();
            if (signatures.hasNext()) {
                PGPSignature signature = (PGPSignature)signatures.next();
                this.setSignatureAttributes(signature);
                if (onePassSignature == null) {
                    VerifyContentPGP.this.getLogger().debug("One-Pass Signature not found: Verification Failed");
                } else {
                    try {
                        this.verified = onePassSignature.verify(signature);
                    }
                    catch (PGPException e) {
                        String keyId = KeyIdentifierConverter.format((long)onePassSignature.getKeyID());
                        throw new PGPProcessException(String.format("One-Pass Signature Key ID [%s] Verification Failed", keyId), e);
                    }
                }
            }
        }

        private void processSignedStream(InputStream inputStream, OutputStream outputStream, PGPOnePassSignature onePassSignature) throws IOException {
            int read;
            String keyId = KeyIdentifierConverter.format((long)onePassSignature.getKeyID());
            VerifyContentPGP.this.getLogger().debug("Processing Data for One-Pass Signature with Key ID [{}]", new Object[]{keyId});
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) >= 0) {
                onePassSignature.update(buffer, 0, read);
                outputStream.write(buffer, 0, read);
            }
        }

        private void setOnePassSignatureAttributes(PGPOnePassSignature onePassSignature) {
            this.setSignatureAlgorithm(onePassSignature.getKeyAlgorithm(), onePassSignature.getHashAlgorithm());
            this.attributes.put("pgp.signature.key.id", KeyIdentifierConverter.format((long)onePassSignature.getKeyID()));
            this.attributes.put("pgp.signature.type.id", Integer.toString(onePassSignature.getSignatureType()));
        }

        private void setSignatureAttributes(PGPSignature signature) {
            this.setSignatureAlgorithm(signature.getKeyAlgorithm(), signature.getHashAlgorithm());
            this.attributes.put("pgp.signature.created", Long.toString(signature.getCreationTime().getTime()));
            this.attributes.put("pgp.signature.key.id", KeyIdentifierConverter.format((long)signature.getKeyID()));
            this.attributes.put("pgp.signature.type.id", Integer.toString(signature.getSignatureType()));
            this.attributes.put("pgp.signature.version", Integer.toString(signature.getVersion()));
        }

        private void setLiteralDataAttributes(PGPLiteralData literalData) {
            this.attributes.put("pgp.literal.data.filename", literalData.getFileName());
            this.attributes.put("pgp.literal.data.modified", Long.toString(literalData.getModificationTime().getTime()));
        }

        private void setSignatureAlgorithm(int keyAlgorithm, int hashAlgorithm) {
            this.attributes.put("pgp.signature.hash.algorithm.id", Integer.toString(hashAlgorithm));
            this.attributes.put("pgp.signature.key.algorithm.id", Integer.toString(keyAlgorithm));
            try {
                String algorithm = PGPUtil.getSignatureName((int)keyAlgorithm, (int)hashAlgorithm);
                this.attributes.put("pgp.signature.algorithm", algorithm);
            }
            catch (PGPException e) {
                VerifyContentPGP.this.getLogger().debug("Signature Algorithm Key Identifier [{}] Hash Identifier [{}] not found", new Object[]{keyAlgorithm, hashAlgorithm});
            }
        }
    }
}

