/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.pgp.service.api.KeyIdentifierConverter;
import org.apache.nifi.pgp.service.api.PGPPrivateKeyService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.pgp.DecryptContentPGP;
import org.apache.nifi.processors.pgp.EncryptContentPGP;
import org.apache.nifi.processors.pgp.VerifyContentPGP;
import org.apache.nifi.processors.pgp.attributes.CompressionAlgorithm;
import org.apache.nifi.processors.pgp.attributes.FileEncoding;
import org.apache.nifi.processors.pgp.attributes.HashAlgorithm;
import org.apache.nifi.processors.pgp.attributes.SigningStrategy;
import org.apache.nifi.processors.pgp.exception.PGPProcessException;
import org.apache.nifi.processors.pgp.io.EncodingStreamCallback;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"PGP", "GPG", "OpenPGP", "Encryption", "Signing", "RFC 4880"})
@CapabilityDescription(value="Sign content using OpenPGP Private Keys")
@SeeAlso(value={DecryptContentPGP.class, EncryptContentPGP.class, VerifyContentPGP.class})
@WritesAttributes(value={@WritesAttribute(attribute="pgp.compression.algorithm", description="Compression Algorithm"), @WritesAttribute(attribute="pgp.compression.algorithm.id", description="Compression Algorithm Identifier"), @WritesAttribute(attribute="pgp.file.encoding", description="File Encoding"), @WritesAttribute(attribute="pgp.signature.algorithm", description="Signature Algorithm including key and hash algorithm names"), @WritesAttribute(attribute="pgp.signature.hash.algorithm.id", description="Signature Hash Algorithm Identifier"), @WritesAttribute(attribute="pgp.signature.key.algorithm.id", description="Signature Key Algorithm Identifier"), @WritesAttribute(attribute="pgp.signature.key.id", description="Signature Public Key Identifier"), @WritesAttribute(attribute="pgp.signature.type.id", description="Signature Type Identifier"), @WritesAttribute(attribute="pgp.signature.version", description="Signature Version Number")})
public class SignContentPGP
extends AbstractProcessor {
    public static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Content signing succeeded").build();
    public static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Content signing failed").build();
    public static final PropertyDescriptor FILE_ENCODING = new PropertyDescriptor.Builder().name("file-encoding").displayName("File Encoding").description("File Encoding for signing").required(true).defaultValue(FileEncoding.BINARY.name()).allowableValues((Enum[])FileEncoding.values()).build();
    public static final PropertyDescriptor HASH_ALGORITHM = new PropertyDescriptor.Builder().name("hash-algorithm").displayName("Hash Algorithm").description("Hash Algorithm for signing").required(true).defaultValue(HashAlgorithm.SHA512.name()).allowableValues((Enum[])HashAlgorithm.values()).build();
    public static final PropertyDescriptor SIGNING_STRATEGY = new PropertyDescriptor.Builder().name("signing-strategy").displayName("Signing Strategy").description("Strategy for writing files to success after signing").required(true).defaultValue(SigningStrategy.SIGNED.name()).allowableValues((DescribedValue[])Arrays.stream(SigningStrategy.values()).map(strategy -> new AllowableValue(strategy.name(), strategy.name(), strategy.getDescription())).toArray(AllowableValue[]::new)).build();
    public static final PropertyDescriptor PRIVATE_KEY_SERVICE = new PropertyDescriptor.Builder().name("private-key-service").displayName("Private Key Service").description("PGP Private Key Service for generating content signatures").identifiesControllerService(PGPPrivateKeyService.class).required(true).build();
    public static final PropertyDescriptor PRIVATE_KEY_ID = new PropertyDescriptor.Builder().name("private-key-id").displayName("Private Key ID").description("PGP Private Key Identifier formatted as uppercase hexadecimal string of 16 characters used for signing").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).required(true).build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(SUCCESS, FAILURE);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(FILE_ENCODING, HASH_ALGORITHM, SIGNING_STRATEGY, PRIVATE_KEY_SERVICE, PRIVATE_KEY_ID);
    private static final boolean NESTED_SIGNATURE_DISABLED = false;
    private static final CompressionAlgorithm COMPRESSION_DISABLED = CompressionAlgorithm.UNCOMPRESSED;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            SignatureStreamCallback callback = this.getStreamCallback(context, flowFile);
            flowFile = session.write(flowFile, (StreamCallback)callback);
            flowFile = session.putAllAttributes(flowFile, callback.attributes);
            session.transfer(flowFile, SUCCESS);
        }
        catch (RuntimeException e) {
            this.getLogger().error("Signing Failed {}", new Object[]{flowFile, e});
            session.transfer(flowFile, FAILURE);
        }
    }

    private SignatureStreamCallback getStreamCallback(ProcessContext context, FlowFile flowFile) {
        FileEncoding fileEncoding = this.getFileEncoding(context);
        HashAlgorithm hashAlgorithm = this.getHashAlgorithm(context);
        String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
        SigningStrategy signingStrategy = this.getSigningStrategy(context);
        PGPPrivateKey privateKey = this.getPrivateKey(context, flowFile);
        return SigningStrategy.SIGNED.equals((Object)signingStrategy) ? new SignedStreamCallback(this, fileEncoding, filename, hashAlgorithm, privateKey) : new DetachedStreamCallback(this, fileEncoding, filename, hashAlgorithm, privateKey);
    }

    private PGPPrivateKey getPrivateKey(ProcessContext context, FlowFile flowFile) {
        PGPPrivateKeyService privateKeyService = (PGPPrivateKeyService)context.getProperty(PRIVATE_KEY_SERVICE).asControllerService(PGPPrivateKeyService.class);
        long privateKeyId = this.getPrivateKeyId(context, flowFile);
        Optional optionalPrivateKey = privateKeyService.findPrivateKey(privateKeyId);
        return (PGPPrivateKey)optionalPrivateKey.orElseThrow(() -> {
            String message = String.format("Private Key ID [%s] not found", KeyIdentifierConverter.format((long)privateKeyId));
            return new PGPProcessException(message);
        });
    }

    private long getPrivateKeyId(ProcessContext context, FlowFile flowFile) {
        String privateKeyId = context.getProperty(PRIVATE_KEY_ID).evaluateAttributeExpressions(flowFile).getValue();
        try {
            return KeyIdentifierConverter.parse((String)privateKeyId);
        }
        catch (NumberFormatException e) {
            throw new PGPProcessException(String.format("Private Key ID [%s] Hexadecimal Parsing Failed", privateKeyId), e);
        }
    }

    private FileEncoding getFileEncoding(ProcessContext context) {
        String encoding = context.getProperty(FILE_ENCODING).getValue();
        return FileEncoding.valueOf(encoding);
    }

    private HashAlgorithm getHashAlgorithm(ProcessContext context) {
        String algorithm = context.getProperty(HASH_ALGORITHM).getValue();
        return HashAlgorithm.valueOf(algorithm);
    }

    private SigningStrategy getSigningStrategy(ProcessContext context) {
        String strategy = context.getProperty(SIGNING_STRATEGY).getValue();
        return SigningStrategy.valueOf(strategy);
    }

    private class SignatureStreamCallback
    extends EncodingStreamCallback {
        private final PGPPrivateKey privateKey;
        private final HashAlgorithm hashAlgorithm;
        private final Map<String, String> attributes;

        protected SignatureStreamCallback(FileEncoding fileEncoding, String filename, HashAlgorithm hashAlgorithm, PGPPrivateKey privateKey) {
            super(fileEncoding, COMPRESSION_DISABLED, filename);
            this.attributes = new HashMap<String, String>();
            this.hashAlgorithm = hashAlgorithm;
            this.privateKey = privateKey;
            this.attributes.put("pgp.compression.algorithm", COMPRESSION_DISABLED.toString());
            this.attributes.put("pgp.compression.algorithm.id", Integer.toString(COMPRESSION_DISABLED.getId()));
            this.attributes.put("pgp.file.encoding", fileEncoding.toString());
        }

        protected void writeSignature(PGPSignatureGenerator signatureGenerator, OutputStream outputStream) throws PGPException, IOException {
            PGPSignature signature = signatureGenerator.generate();
            signature.encode(outputStream);
            this.setSignatureAttributes(signature);
        }

        protected PGPSignatureGenerator getSignatureGenerator() throws PGPException {
            int keyAlgorithm = this.privateKey.getPublicKeyPacket().getAlgorithm();
            SecureRandom secureRandom = new SecureRandom();
            JcaPGPContentSignerBuilder builder = new JcaPGPContentSignerBuilder(keyAlgorithm, this.hashAlgorithm.getId()).setSecureRandom(secureRandom);
            JcaKeyFingerprintCalculator keyFingerprintCalculator = new JcaKeyFingerprintCalculator();
            PGPPublicKey pgpPublicKey = new PGPPublicKey(this.privateKey.getPublicKeyPacket(), (KeyFingerPrintCalculator)keyFingerprintCalculator);
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)builder, pgpPublicKey);
            signatureGenerator.init(0, this.privateKey);
            return signatureGenerator;
        }

        private void setSignatureAttributes(PGPSignature signature) {
            this.setSignatureAlgorithm(signature.getKeyAlgorithm(), signature.getHashAlgorithm());
            this.attributes.put("pgp.signature.created", Long.toString(signature.getCreationTime().getTime()));
            this.attributes.put("pgp.signature.key.id", KeyIdentifierConverter.format((long)signature.getKeyID()));
            this.attributes.put("pgp.signature.type.id", Integer.toString(signature.getSignatureType()));
            this.attributes.put("pgp.signature.version", Integer.toString(signature.getVersion()));
        }

        private void setSignatureAlgorithm(int keyAlgorithm, int hashAlgorithm) {
            this.attributes.put("pgp.signature.hash.algorithm.id", Integer.toString(hashAlgorithm));
            this.attributes.put("pgp.signature.key.algorithm.id", Integer.toString(keyAlgorithm));
            try {
                String algorithm = PGPUtil.getSignatureName((int)keyAlgorithm, (int)hashAlgorithm);
                this.attributes.put("pgp.signature.algorithm", algorithm);
            }
            catch (PGPException e) {
                SignContentPGP.this.getLogger().debug("Signature Algorithm Key Identifier [{}] Hash Identifier [{}] not found", new Object[]{keyAlgorithm, hashAlgorithm});
            }
        }
    }

    private class SignedStreamCallback
    extends SignatureStreamCallback {
        private SignedStreamCallback(SignContentPGP signContentPGP, FileEncoding fileEncoding, String filename, HashAlgorithm hashAlgorithm, PGPPrivateKey privateKey) {
            super(fileEncoding, filename, hashAlgorithm, privateKey);
        }

        @Override
        protected void processCompression(InputStream inputStream, OutputStream compressedOutputStream) throws IOException, PGPException {
            PGPSignatureGenerator signatureGenerator = this.getSignatureGenerator();
            PGPOnePassSignature onePassSignature = signatureGenerator.generateOnePassVersion(false);
            onePassSignature.encode(compressedOutputStream);
            PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
            try (OutputStream literalOutputStream = this.openLiteralOutputStream(literalDataGenerator, compressedOutputStream);){
                this.processSigned(inputStream, literalOutputStream, signatureGenerator);
            }
            literalDataGenerator.close();
            this.writeSignature(signatureGenerator, compressedOutputStream);
        }

        private void processSigned(InputStream inputStream, OutputStream outputStream, PGPSignatureGenerator signatureGenerator) throws IOException {
            int read;
            byte[] buffer = this.createOutputBuffer();
            while ((read = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, read);
                signatureGenerator.update(buffer, 0, read);
            }
        }
    }

    private class DetachedStreamCallback
    extends SignatureStreamCallback {
        private DetachedStreamCallback(SignContentPGP signContentPGP, FileEncoding fileEncoding, String filename, HashAlgorithm hashAlgorithm, PGPPrivateKey privateKey) {
            super(fileEncoding, filename, hashAlgorithm, privateKey);
        }

        @Override
        protected void processEncoding(InputStream inputStream, OutputStream encodingOutputStream) throws IOException, PGPException {
            this.processDetached(inputStream, encodingOutputStream);
        }

        private void processDetached(InputStream inputStream, OutputStream outputStream) throws IOException, PGPException {
            int read;
            PGPSignatureGenerator signatureGenerator = this.getSignatureGenerator();
            byte[] buffer = this.createOutputBuffer();
            while ((read = inputStream.read(buffer)) >= 0) {
                signatureGenerator.update(buffer, 0, read);
            }
            this.writeSignature(signatureGenerator, outputStream);
        }
    }
}

