/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.encoding;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.google.protobuf.Message;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import org.apache.nifi.processors.opentelemetry.encoding.HexadecimalMessageType;
import org.apache.nifi.processors.opentelemetry.encoding.StandardMessageDeserializerFactory;
import org.apache.nifi.processors.opentelemetry.encoding.TelemetryMessageSerializer;

public class StandardProtobufModule
extends ProtobufModule {
    private static final ProtobufJacksonConfig protobufJacksonConfig = ProtobufJacksonConfig.builder().properUnsignedNumberSerialization(true).build();

    public StandardProtobufModule() {
        super(protobufJacksonConfig);
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        TelemetryMessageSerializer telemetryMessageSerializer = new TelemetryMessageSerializer(protobufJacksonConfig);
        SimpleSerializers serializers = new SimpleSerializers();
        for (HexadecimalMessageType hexadecimalMessageType : HexadecimalMessageType.values()) {
            Class<? extends Message> messageType = hexadecimalMessageType.getMessageType();
            serializers.addSerializer(messageType, (JsonSerializer)telemetryMessageSerializer);
        }
        context.addSerializers((Serializers)serializers);
        StandardMessageDeserializerFactory deserializerFactory = new StandardMessageDeserializerFactory(protobufJacksonConfig);
        context.addDeserializers((Deserializers)deserializerFactory);
    }
}

