/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.protocol;

import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.nifi.processors.opentelemetry.protocol.ServiceRequestDescription;
import org.apache.nifi.processors.opentelemetry.protocol.TelemetryContentEncoding;
import org.apache.nifi.processors.opentelemetry.protocol.TelemetryContentType;
import org.apache.nifi.processors.opentelemetry.protocol.TelemetryRequestType;

public class StandardServiceRequestDescription
implements ServiceRequestDescription {
    private final TelemetryContentEncoding contentEncoding;
    private final TelemetryContentType contentType;
    private final TelemetryRequestType requestType;
    private final InetSocketAddress remoteAddress;

    public StandardServiceRequestDescription(TelemetryContentEncoding contentEncoding, TelemetryContentType contentType, TelemetryRequestType requestType, InetSocketAddress remoteAddress) {
        this.contentEncoding = Objects.requireNonNull(contentEncoding, "Content Encoding required");
        this.contentType = Objects.requireNonNull(contentType, "Content Type required");
        this.requestType = Objects.requireNonNull(requestType, "Request Type required");
        this.remoteAddress = Objects.requireNonNull(remoteAddress, "Remote Address required");
    }

    @Override
    public TelemetryContentEncoding getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public TelemetryContentType getContentType() {
        return this.contentType;
    }

    @Override
    public TelemetryRequestType getRequestType() {
        return this.requestType;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }
}

