/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;

@Tags(value={"example", "resources"})
@CapabilityDescription(value="This example processor loads a resource from the nar and writes it to the FlowFile content")
public class WriteResourceToStream
extends AbstractProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("files that were successfully processed").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("files that were not successfully processed").build();
    private Set<Relationship> relationships;
    private String resourceData;

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
        InputStream resourceStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("file.txt");
        try {
            this.resourceData = IOUtils.toString((InputStream)resourceStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load resources", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceStream);
        }
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            flowFile = session.write(flowFile, new OutputStreamCallback(){

                public void process(OutputStream out) throws IOException {
                    IOUtils.write((String)WriteResourceToStream.this.resourceData, (OutputStream)out, (Charset)Charset.defaultCharset());
                }
            });
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (ProcessException ex) {
            this.getLogger().error("Unable to process", (Throwable)ex);
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

