/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.nar.NarBundleUtil;
import org.apache.nifi.nar.NarClassLoader;
import org.apache.nifi.nar.NarLoadResult;
import org.apache.nifi.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NarClassLoaders {
    public static final String FRAMEWORK_NAR_ID = "nifi-framework-nar";
    public static final String JETTY_NAR_ID = "nifi-jetty-bundle";
    private volatile InitContext initContext;
    private static final Logger logger = LoggerFactory.getLogger(NarClassLoaders.class);

    public void init(File frameworkWorkingDir, File extensionsWorkingDir) throws IOException, ClassNotFoundException {
        this.init(ClassLoader.getSystemClassLoader(), frameworkWorkingDir, extensionsWorkingDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ClassLoader rootClassloader, File frameworkWorkingDir, File extensionsWorkingDir) throws IOException, ClassNotFoundException {
        boolean matching;
        if (extensionsWorkingDir == null) {
            throw new NullPointerException("cannot have empty arguments");
        }
        InitContext ic = this.initContext;
        if (ic == null) {
            NarClassLoaders narClassLoaders = this;
            synchronized (narClassLoaders) {
                ic = this.initContext;
                if (ic == null) {
                    this.initContext = ic = this.load(rootClassloader, frameworkWorkingDir, extensionsWorkingDir);
                }
            }
        }
        boolean bl = matching = this.initContext.extensionWorkingDir.equals(extensionsWorkingDir) && Objects.equals(this.initContext.frameworkWorkingDir, frameworkWorkingDir);
        if (!matching) {
            throw new IllegalStateException("Cannot reinitialize and extension/framework directories cannot change");
        }
    }

    private InitContext load(ClassLoader rootClassloader, File frameworkWorkingDir, File extensionsWorkingDir) throws IOException, ClassNotFoundException {
        LinkedHashMap<String, Bundle> narDirectoryBundleLookup = new LinkedHashMap<String, Bundle>();
        HashMap<String, ClassLoader> narCoordinateClassLoaderLookup = new HashMap<String, ClassLoader>();
        HashMap<String, Set> narIdBundleLookup = new HashMap<String, Set>();
        ArrayList<File> narWorkingDirContents = new ArrayList<File>();
        if (frameworkWorkingDir != null) {
            FileUtils.ensureDirectoryExistAndCanReadAndWrite(frameworkWorkingDir);
            File[] frameworkWorkingDirContents = frameworkWorkingDir.listFiles();
            if (frameworkWorkingDirContents != null) {
                narWorkingDirContents.addAll(Arrays.asList(frameworkWorkingDirContents));
            }
        }
        FileUtils.ensureDirectoryExistAndCanReadAndWrite(extensionsWorkingDir);
        File[] extensionsWorkingDirContents = extensionsWorkingDir.listFiles();
        if (extensionsWorkingDirContents != null) {
            narWorkingDirContents.addAll(Arrays.asList(extensionsWorkingDirContents));
        }
        if (!narWorkingDirContents.isEmpty()) {
            int narCount;
            BundleDetails narDetail;
            ArrayList<BundleDetails> narDetails = new ArrayList<BundleDetails>();
            HashMap<String, String> narCoordinatesToWorkingDir = new HashMap<String, String>();
            for (File unpackedNar : narWorkingDirContents) {
                narDetail = null;
                try {
                    narDetail = NarClassLoaders.getNarDetails(unpackedNar);
                }
                catch (IllegalStateException e) {
                    logger.warn("Unable to load NAR {} due to {}, skipping...", new Object[]{unpackedNar.getAbsolutePath(), e.getMessage()});
                    continue;
                }
                String narCoordinate = narDetail.getCoordinate().getCoordinate();
                if (narCoordinatesToWorkingDir.containsKey(narCoordinate)) {
                    String existingNarWorkingDir = (String)narCoordinatesToWorkingDir.get(narCoordinate);
                    throw new IllegalStateException("Unable to load NAR with coordinates " + narCoordinate + " and working directory " + narDetail.getWorkingDirectory() + " because another NAR with the same coordinates already exists at " + existingNarWorkingDir);
                }
                narDetails.add(narDetail);
                narCoordinatesToWorkingDir.put(narCoordinate, narDetail.getWorkingDirectory().getCanonicalPath());
            }
            ClassLoader jettyClassLoader = null;
            Iterator narDetailsIter = narDetails.iterator();
            while (narDetailsIter.hasNext()) {
                narDetail = (BundleDetails)narDetailsIter.next();
                if (JETTY_NAR_ID.equals(narDetail.getCoordinate().getId())) {
                    jettyClassLoader = NarClassLoaders.createNarClassLoader(narDetail.getWorkingDirectory(), rootClassloader);
                    narDirectoryBundleLookup.put(narDetail.getWorkingDirectory().getCanonicalPath(), new Bundle(narDetail, jettyClassLoader));
                    narCoordinateClassLoaderLookup.put(narDetail.getCoordinate().getCoordinate(), jettyClassLoader);
                    narDetailsIter.remove();
                }
                narIdBundleLookup.computeIfAbsent(narDetail.getCoordinate().getId(), id -> new HashSet()).add(narDetail.getCoordinate());
            }
            if (jettyClassLoader == null) {
                throw new IllegalStateException("Unable to locate Jetty bundle.");
            }
            do {
                narCount = narDetails.size();
                Iterator narDetailsIter2 = narDetails.iterator();
                while (narDetailsIter2.hasNext()) {
                    ClassLoader bundleClassLoader;
                    BundleDetails narDetail2 = (BundleDetails)narDetailsIter2.next();
                    BundleCoordinate narDependencyCoordinate = narDetail2.getDependencyCoordinate();
                    ClassLoader narClassLoader = null;
                    if (narDependencyCoordinate == null) {
                        narClassLoader = NarClassLoaders.createNarClassLoader(narDetail2.getWorkingDirectory(), jettyClassLoader);
                    } else {
                        String dependencyCoordinateStr = narDependencyCoordinate.getCoordinate();
                        if (narCoordinateClassLoaderLookup.containsKey(dependencyCoordinateStr)) {
                            ClassLoader narDependencyClassLoader = (ClassLoader)narCoordinateClassLoaderLookup.get(dependencyCoordinateStr);
                            narClassLoader = NarClassLoaders.createNarClassLoader(narDetail2.getWorkingDirectory(), narDependencyClassLoader);
                        } else {
                            BundleCoordinate coordinate;
                            Set coordinates = (Set)narIdBundleLookup.get(narDependencyCoordinate.getId());
                            if (coordinates != null && !coordinates.contains(narDependencyCoordinate) && coordinates.size() == 1 && narCoordinateClassLoaderLookup.containsKey((coordinate = (BundleCoordinate)coordinates.stream().findFirst().get()).getCoordinate())) {
                                logger.warn(String.format("While loading '%s' unable to locate exact NAR dependency '%s'. Only found one possible match '%s'. Continuing...", narDetail2.getCoordinate().getCoordinate(), dependencyCoordinateStr, coordinate.getCoordinate()));
                                ClassLoader narDependencyClassLoader = (ClassLoader)narCoordinateClassLoaderLookup.get(coordinate.getCoordinate());
                                narClassLoader = NarClassLoaders.createNarClassLoader(narDetail2.getWorkingDirectory(), narDependencyClassLoader);
                            }
                        }
                    }
                    if ((bundleClassLoader = narClassLoader) == null) continue;
                    narDirectoryBundleLookup.put(narDetail2.getWorkingDirectory().getCanonicalPath(), new Bundle(narDetail2, bundleClassLoader));
                    narCoordinateClassLoaderLookup.put(narDetail2.getCoordinate().getCoordinate(), narClassLoader);
                    narDetailsIter2.remove();
                }
            } while (narCount != narDetails.size());
            for (BundleDetails narDetail2 : narDetails) {
                logger.warn(String.format("Unable to resolve required dependency '%s'. Skipping NAR '%s'", narDetail2.getDependencyCoordinate().getId(), narDetail2.getWorkingDirectory().getAbsolutePath()));
            }
        }
        Bundle frameworkBundle = narDirectoryBundleLookup.values().stream().filter(b -> b.getBundleDetails().getCoordinate().getId().equals(FRAMEWORK_NAR_ID)).findFirst().orElse(null);
        Bundle jettyBundle = narDirectoryBundleLookup.values().stream().filter(b -> b.getBundleDetails().getCoordinate().getId().equals(JETTY_NAR_ID)).findFirst().orElse(null);
        if (jettyBundle == null) {
            throw new IllegalStateException("Unable to locate Jetty bundle.");
        }
        return new InitContext(frameworkWorkingDir, extensionsWorkingDir, frameworkBundle, jettyBundle, new LinkedHashMap(narDirectoryBundleLookup));
    }

    public synchronized NarLoadResult loadAdditionalNars(List<File> additionalUnpackedNars) {
        int bundleCount;
        BundleDetails bundleDetail;
        if (this.initContext == null) {
            throw new IllegalStateException("Must call init before attempting to load additional NARs");
        }
        LinkedHashSet<Bundle> loadedBundles = new LinkedHashSet<Bundle>();
        List<BundleDetails> additionalBundleDetails = this.loadBundleDetails(additionalUnpackedNars);
        HashMap<String, Set<BundleCoordinate>> bundleIdToCoordinatesLookup = new HashMap<String, Set<BundleCoordinate>>();
        for (BundleDetails bundleDetail2 : additionalBundleDetails) {
            String bundleId = bundleDetail2.getCoordinate().getId();
            Set coordinates = bundleIdToCoordinatesLookup.computeIfAbsent(bundleId, id -> new HashSet());
            coordinates.add(bundleDetail2.getCoordinate());
        }
        for (Bundle bundle : this.getBundles()) {
            bundleDetail = bundle.getBundleDetails();
            String bundleId = bundleDetail.getCoordinate().getId();
            Set coordinates = bundleIdToCoordinatesLookup.computeIfAbsent(bundleId, id -> new HashSet());
            coordinates.add(bundleDetail.getCoordinate());
        }
        do {
            bundleCount = additionalBundleDetails.size();
            Iterator<BundleDetails> additionalBundleDetailsIter = additionalBundleDetails.iterator();
            while (additionalBundleDetailsIter.hasNext()) {
                bundleDetail = additionalBundleDetailsIter.next();
                try {
                    ClassLoader bundleClassLoader = this.createBundleClassLoader(bundleDetail, bundleIdToCoordinatesLookup);
                    if (bundleClassLoader == null) continue;
                    Bundle bundle = new Bundle(bundleDetail, bundleClassLoader);
                    loadedBundles.add(bundle);
                    additionalBundleDetailsIter.remove();
                    this.initContext.bundles.put(bundleDetail.getWorkingDirectory().getCanonicalPath(), bundle);
                }
                catch (Exception e) {
                    logger.error("Unable to load NAR {} due to {}, skipping...", new Object[]{bundleDetail.getWorkingDirectory(), e.getMessage()});
                }
            }
        } while (bundleCount != additionalBundleDetails.size());
        HashSet<BundleDetails> skippedBundles = new HashSet<BundleDetails>();
        for (BundleDetails bundleDetail3 : additionalBundleDetails) {
            logger.warn(String.format("Unable to resolve required dependency '%s'. Skipping NAR '%s'", bundleDetail3.getDependencyCoordinate().getId(), bundleDetail3.getWorkingDirectory().getAbsolutePath()));
            skippedBundles.add(bundleDetail3);
        }
        return new NarLoadResult(loadedBundles, skippedBundles);
    }

    private ClassLoader createBundleClassLoader(BundleDetails bundleDetail, Map<String, Set<BundleCoordinate>> bundleIdToCoordinatesLookup) throws IOException, ClassNotFoundException {
        ClassLoader bundleClassLoader = null;
        BundleCoordinate bundleDependencyCoordinate = bundleDetail.getDependencyCoordinate();
        if (bundleDependencyCoordinate == null) {
            ClassLoader jettyClassLoader = this.getJettyBundle().getClassLoader();
            bundleClassLoader = NarClassLoaders.createNarClassLoader(bundleDetail.getWorkingDirectory(), jettyClassLoader);
        } else {
            Optional<Bundle> dependencyBundle = this.getBundle(bundleDependencyCoordinate);
            if (dependencyBundle.isPresent()) {
                ClassLoader narDependencyClassLoader = dependencyBundle.get().getClassLoader();
                bundleClassLoader = NarClassLoaders.createNarClassLoader(bundleDetail.getWorkingDirectory(), narDependencyClassLoader);
            } else {
                BundleCoordinate coordinate;
                Optional<Bundle> matchingDependencyIdBundle;
                Set<BundleCoordinate> coordinates = bundleIdToCoordinatesLookup.get(bundleDependencyCoordinate.getId());
                if (coordinates != null && !coordinates.contains(bundleDependencyCoordinate) && coordinates.size() == 1 && (matchingDependencyIdBundle = this.getBundle(coordinate = (BundleCoordinate)coordinates.stream().findFirst().get())).isPresent()) {
                    String dependencyCoordinateStr = bundleDependencyCoordinate.getCoordinate();
                    logger.warn(String.format("While loading '%s' unable to locate exact NAR dependency '%s'. Only found one possible match '%s'. Continuing...", bundleDetail.getCoordinate().getCoordinate(), dependencyCoordinateStr, coordinate.getCoordinate()));
                    ClassLoader narDependencyClassLoader = matchingDependencyIdBundle.get().getClassLoader();
                    bundleClassLoader = NarClassLoaders.createNarClassLoader(bundleDetail.getWorkingDirectory(), narDependencyClassLoader);
                }
            }
        }
        return bundleClassLoader;
    }

    private List<BundleDetails> loadBundleDetails(List<File> unpackedNars) {
        ArrayList<BundleDetails> narDetails = new ArrayList<BundleDetails>();
        for (File unpackedNar : unpackedNars) {
            try {
                BundleDetails narDetail = NarClassLoaders.getNarDetails(unpackedNar);
                BundleCoordinate unpackedNarCoordinate = narDetail.getCoordinate();
                Optional<Bundle> existingBundle = this.getBundle(unpackedNarCoordinate);
                if (existingBundle.isPresent()) {
                    BundleDetails existingBundleDetails = existingBundle.get().getBundleDetails();
                    String existingNarWorkingDir = existingBundleDetails.getWorkingDirectory().getCanonicalPath();
                    String unpackedNarWorkingDir = narDetail.getWorkingDirectory().getCanonicalPath();
                    logger.error("Unable to load NAR with coordinates {} and working directory {} because another NAR with the same coordinates already exists at {}", new Object[]{unpackedNarCoordinate, unpackedNarWorkingDir, existingNarWorkingDir});
                    continue;
                }
                narDetails.add(narDetail);
            }
            catch (Exception e) {
                logger.error("Unable to load NAR {} due to {}, skipping...", new Object[]{unpackedNar.getAbsolutePath(), e.getMessage()});
            }
        }
        return narDetails;
    }

    private static ClassLoader createNarClassLoader(File narDirectory, ClassLoader parentClassLoader) throws IOException, ClassNotFoundException {
        logger.debug("Loading NAR file: " + narDirectory.getAbsolutePath());
        NarClassLoader narClassLoader = new NarClassLoader(narDirectory, parentClassLoader);
        logger.info("Loaded NAR file: " + narDirectory.getAbsolutePath() + " as class loader " + narClassLoader);
        return narClassLoader;
    }

    private static BundleDetails getNarDetails(File narDirectory) throws IOException {
        return NarBundleUtil.fromNarDirectory(narDirectory);
    }

    private Optional<Bundle> getBundle(BundleCoordinate bundleCoordinate) {
        return this.initContext.bundles.values().stream().filter(b -> b.getBundleDetails().getCoordinate().equals((Object)bundleCoordinate)).findFirst();
    }

    public Bundle getFrameworkBundle() {
        if (this.initContext == null) {
            throw new IllegalStateException("Framework bundle has not been loaded.");
        }
        return this.initContext.frameworkBundle;
    }

    public Bundle getJettyBundle() {
        if (this.initContext == null) {
            throw new IllegalStateException("Jetty bundle has not been loaded.");
        }
        return this.initContext.jettyBundle;
    }

    public Bundle getBundle(File extensionWorkingDirectory) {
        if (this.initContext == null) {
            throw new IllegalStateException("Extensions class loaders have not been loaded.");
        }
        try {
            return (Bundle)this.initContext.bundles.get(extensionWorkingDirectory.getCanonicalPath());
        }
        catch (IOException ioe) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to get extension classloader for working directory '{}'", (Object)extensionWorkingDirectory);
            }
            return null;
        }
    }

    public Set<Bundle> getBundles() {
        if (this.initContext == null) {
            throw new IllegalStateException("Bundles have not been loaded.");
        }
        return new LinkedHashSet<Bundle>(this.initContext.bundles.values());
    }

    private static final class InitContext {
        private final File frameworkWorkingDir;
        private final File extensionWorkingDir;
        private final Bundle frameworkBundle;
        private final Bundle jettyBundle;
        private final Map<String, Bundle> bundles;

        private InitContext(File frameworkDir, File extensionDir, Bundle frameworkBundle, Bundle jettyBundle, Map<String, Bundle> bundles) {
            this.frameworkWorkingDir = frameworkDir;
            this.extensionWorkingDir = extensionDir;
            this.frameworkBundle = frameworkBundle;
            this.jettyBundle = jettyBundle;
            this.bundles = bundles;
        }
    }
}

