/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.nifi.utils.NarDependencyUtils;
import org.eclipse.aether.RepositorySystemSession;

@Mojo(name="provided-nar-dependencies", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class NarProvidedDependenciesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(property="mode", defaultValue="tree")
    private String mode;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ProjectBuilder projectBuilder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            NarDependencyUtils.ensureSingleNarDependencyExists(this.project);
            DefaultProjectBuildingRequest narRequest = new DefaultProjectBuildingRequest();
            narRequest.setRepositorySession(this.repoSession);
            narRequest.setSystemProperties(System.getProperties());
            this.artifactHandlerManager.addHandlers(NarDependencyUtils.createNarHandlerMap((ProjectBuildingRequest)narRequest, this.project, this.projectBuilder));
            DependencyNode root = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)narRequest, null);
            Object visitor = null;
            if ("tree".equals(this.mode)) {
                visitor = new TreeWriter();
            } else if ("pom".equals(this.mode)) {
                visitor = new PomWriter();
            }
            if (visitor == null) {
                throw new MojoExecutionException("The specified mode is invalid. Supported options are 'tree' and 'pom'.");
            }
            root.accept((DependencyNodeVisitor)visitor);
            this.getLog().info((CharSequence)("--- Provided NAR Dependencies ---" + System.lineSeparator() + System.lineSeparator() + String.valueOf(visitor)));
        }
        catch (ProjectBuildingException | DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Cannot build project dependency tree", (Exception)e);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    private boolean isTest(DependencyNode node) {
        return "test".equals(node.getArtifact().getScope());
    }

    private class TreeWriter
    implements DependencyNodeVisitor {
        private final StringBuilder output = new StringBuilder();
        private final Deque<DependencyNode> hierarchy = new ArrayDeque<DependencyNode>();

        private TreeWriter() {
        }

        public boolean visit(DependencyNode node) {
            this.hierarchy.push(node);
            if (NarProvidedDependenciesMojo.this.isTest(node)) {
                return false;
            }
            StringBuilder pad = new StringBuilder();
            for (int i = 0; i < this.hierarchy.size() - 1; ++i) {
                pad.append("   ");
            }
            pad.append("+- ");
            this.output.append((CharSequence)pad).append(node.toNodeString()).append(System.lineSeparator());
            return true;
        }

        public boolean endVisit(DependencyNode node) {
            this.hierarchy.pop();
            return true;
        }

        public String toString() {
            return this.output.toString();
        }
    }

    private class PomWriter
    implements DependencyNodeVisitor {
        private final StringBuilder output = new StringBuilder();

        private PomWriter() {
        }

        public boolean visit(DependencyNode node) {
            if (NarProvidedDependenciesMojo.this.isTest(node)) {
                return false;
            }
            Artifact artifact = node.getArtifact();
            if (!"nar".equals(artifact.getType())) {
                this.output.append("<dependency>").append(System.lineSeparator());
                this.output.append("    <groupId>").append(artifact.getGroupId()).append("</groupId>").append(System.lineSeparator());
                this.output.append("    <artifactId>").append(artifact.getArtifactId()).append("</artifactId>").append(System.lineSeparator());
                this.output.append("    <version>").append(artifact.getVersion()).append("</version>").append(System.lineSeparator());
                this.output.append("    <scope>provided</scope>").append(System.lineSeparator());
                this.output.append("</dependency>").append(System.lineSeparator());
            }
            return true;
        }

        public boolean endVisit(DependencyNode node) {
            return true;
        }

        public String toString() {
            return this.output.toString();
        }
    }
}

