/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mqtt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.mqtt.ConsumeMQTT;
import org.apache.nifi.processors.mqtt.common.AbstractMQTTProcessor;
import org.apache.nifi.processors.mqtt.common.StandardMqttMessage;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"publish", "MQTT", "IOT"})
@CapabilityDescription(value="Publishes a message to an MQTT topic")
@SeeAlso(value={ConsumeMQTT.class})
@SystemResourceConsideration(resource=SystemResource.MEMORY)
public class PublishMQTT
extends AbstractMQTTProcessor {
    public static final PropertyDescriptor PROP_TOPIC = new PropertyDescriptor.Builder().name("Topic").description("The topic to publish the message to.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor PROP_QOS = new PropertyDescriptor.Builder().name("Quality of Service").description("The Quality of Service (QoS) to send the message with. Accepts three values '0', '1' and '2'; '0' for 'at most once', '1' for 'at least once', '2' for 'exactly once'. Expression language is allowed in order to support publishing messages with different QoS but the end value of the property must be either '0', '1' or '2'. ").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(QOS_VALIDATOR).build();
    public static final PropertyDescriptor PROP_RETAIN = new PropertyDescriptor.Builder().name("Retain Message").description("Whether or not the retain flag should be set on the MQTT message.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(RETAIN_VALIDATOR).build();
    public static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().fromPropertyDescriptor(BASE_RECORD_READER).description("The Record Reader to use for parsing the incoming FlowFile into Records.").build();
    public static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().fromPropertyDescriptor(BASE_RECORD_WRITER).description("The Record Writer to use for serializing Records before publishing them as an MQTT Message.").build();
    public static final PropertyDescriptor MESSAGE_DEMARCATOR = new PropertyDescriptor.Builder().fromPropertyDescriptor(BASE_MESSAGE_DEMARCATOR).description("With this property, you have an option to publish multiple messages from a single FlowFile. This property allows you to provide a string (interpreted as UTF-8) to use for demarcating apart the FlowFile content. This is an optional property ; if not provided, and if not defining a Record Reader/Writer, each FlowFile will be published as a single message. To enter special character such as 'new line' use CTRL+Enter or Shift+Enter depending on the OS.").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that are sent successfully to the destination are transferred to this relationship.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that failed to send to the destination are transferred to this relationship.").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(PROP_BROKER_URI, PROP_MQTT_VERSION, PROP_USERNAME, PROP_PASSWORD, PROP_SSL_CONTEXT_SERVICE, PROP_CLEAN_SESSION, PROP_SESSION_EXPIRY_INTERVAL, PROP_CLIENTID, PROP_TOPIC, PROP_RETAIN, PROP_QOS, RECORD_READER, RECORD_WRITER, MESSAGE_DEMARCATOR, PROP_CONN_TIMEOUT, PROP_KEEP_ALIVE_INTERVAL, PROP_LAST_WILL_MESSAGE, PROP_LAST_WILL_TOPIC, PROP_LAST_WILL_RETAIN, PROP_LAST_WILL_QOS);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    static final String ATTR_PUBLISH_FAILED_INDEX_SUFFIX = ".mqtt.publish.failed.index";
    private String publishFailedIndexAttributeName;

    protected void init(ProcessorInitializationContext context) {
        this.logger = this.getLogger();
        this.publishFailedIndexAttributeName = this.getIdentifier() + ATTR_PUBLISH_FAILED_INDEX_SUFFIX;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        super.onScheduled(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnStopped
    public void onStopped(ProcessContext context) {
        PublishMQTT publishMQTT = this;
        synchronized (publishMQTT) {
            this.stopClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String topic;
        FlowFile flowfile = session.get();
        if (flowfile == null) {
            return;
        }
        if (!this.isConnected()) {
            PublishMQTT publishMQTT = this;
            synchronized (publishMQTT) {
                if (!this.isConnected()) {
                    this.initializeClient(context);
                }
            }
        }
        if ((topic = context.getProperty(PROP_TOPIC).evaluateAttributeExpressions(flowfile).getValue()) == null || topic.isEmpty()) {
            this.logger.warn("Evaluation of the topic property returned null or evaluated to be empty, routing to failure");
            session.transfer(flowfile, REL_FAILURE);
            return;
        }
        if (context.getProperty(RECORD_READER).isSet()) {
            this.processMultiMessageFlowFile(new ProcessRecordSetStrategy(), context, session, flowfile, topic);
        } else if (context.getProperty(MESSAGE_DEMARCATOR).isSet()) {
            this.processMultiMessageFlowFile(new ProcessDemarcatedContentStrategy(), context, session, flowfile, topic);
        } else {
            this.processStandardFlowFile(context, session, flowfile, topic);
        }
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("Quality of Service(QoS)", PROP_QOS.getName());
    }

    private void processMultiMessageFlowFile(ProcessStrategy processStrategy, ProcessContext context, ProcessSession session, FlowFile flowfile, String topic) {
        StopWatch stopWatch = new StopWatch(true);
        AtomicInteger processedRecords = new AtomicInteger();
        try {
            String provenanceEventDetails;
            Long previousProcessFailedAt = Optional.ofNullable(flowfile.getAttribute(this.publishFailedIndexAttributeName)).map(Long::valueOf).orElse(null);
            session.read(flowfile, in -> processStrategy.process(context, flowfile, in, topic, processedRecords, previousProcessFailedAt));
            FlowFile successFlowFile = flowfile;
            if (previousProcessFailedAt != null) {
                successFlowFile = session.removeAttribute(flowfile, this.publishFailedIndexAttributeName);
                provenanceEventDetails = String.format(processStrategy.getRecoverTemplateMessage(), processedRecords.get());
            } else {
                provenanceEventDetails = String.format(processStrategy.getSuccessTemplateMessage(), processedRecords.get());
            }
            session.getProvenanceReporter().send(flowfile, this.clientProperties.getRawBrokerUris(), provenanceEventDetails, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            session.transfer(successFlowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.logger.error("An error happened during publishing records. Routing to failure.", (Throwable)e);
            FlowFile failedFlowFile = session.putAttribute(flowfile, this.publishFailedIndexAttributeName, String.valueOf(processedRecords.get()));
            if (processedRecords.get() > 0) {
                session.getProvenanceReporter().send(failedFlowFile, this.clientProperties.getRawBrokerUris(), String.format(processStrategy.getFailureTemplateMessage(), processedRecords.get()), stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            }
            session.transfer(failedFlowFile, REL_FAILURE);
        }
    }

    private void processStandardFlowFile(ProcessContext context, ProcessSession session, FlowFile flowfile, String topic) {
        try {
            byte[] messageContent = new byte[(int)flowfile.getSize()];
            session.read(flowfile, in -> StreamUtils.fillBuffer((InputStream)in, (byte[])messageContent, (boolean)true));
            StopWatch stopWatch = new StopWatch(true);
            this.publishMessage(context, flowfile, topic, messageContent);
            session.getProvenanceReporter().send(flowfile, this.clientProperties.getRawBrokerUris(), stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            session.transfer(flowfile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.logger.error("An error happened during publishing a message. Routing to failure.", (Throwable)e);
            session.transfer(flowfile, REL_FAILURE);
        }
    }

    private void publishMessage(ProcessContext context, FlowFile flowfile, String topic, byte[] messageContent) {
        int qos = context.getProperty(PROP_QOS).evaluateAttributeExpressions(flowfile).asInteger();
        boolean retained = context.getProperty(PROP_RETAIN).evaluateAttributeExpressions(flowfile).asBoolean();
        StandardMqttMessage mqttMessage = new StandardMqttMessage(messageContent, qos, retained);
        this.mqttClient.publish(topic, mqttMessage);
    }

    private void initializeClient(ProcessContext context) {
        try {
            this.mqttClient = this.createMqttClient();
            this.mqttClient.connect();
        }
        catch (Exception e) {
            this.logger.error("Connection failed to {}. Yielding processor", new Object[]{this.clientProperties.getRawBrokerUris(), e});
            context.yield();
        }
    }

    class ProcessRecordSetStrategy
    implements ProcessStrategy {
        static final String PROVENANCE_EVENT_DETAILS_ON_RECORDSET_FAILURE = "Publish failed after %d successfully published records.";
        static final String PROVENANCE_EVENT_DETAILS_ON_RECORDSET_RECOVER = "Successfully finished publishing previously failed records. Total record count: %d";
        static final String PROVENANCE_EVENT_DETAILS_ON_RECORDSET_SUCCESS = "Successfully published all records. Total record count: %d";

        ProcessRecordSetStrategy() {
        }

        @Override
        public void process(ProcessContext context, FlowFile flowfile, InputStream in, String topic, AtomicInteger processedRecords, Long previousProcessFailedAt) throws IOException {
            RecordReaderFactory readerFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
            RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
            try (RecordReader reader = readerFactory.createRecordReader(flowfile, in, PublishMQTT.this.logger);){
                Record record;
                RecordSet recordSet = reader.createRecordSet();
                RecordSchema schema = writerFactory.getSchema(flowfile.getAttributes(), recordSet.getSchema());
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                while ((record = recordSet.next()) != null) {
                    if (previousProcessFailedAt != null && (long)processedRecords.get() < previousProcessFailedAt) {
                        processedRecords.getAndIncrement();
                        continue;
                    }
                    baos.reset();
                    try (RecordSetWriter writer = writerFactory.createWriter(PublishMQTT.this.logger, schema, (OutputStream)baos, flowfile);){
                        writer.write(record);
                        writer.flush();
                    }
                    byte[] messageContent = baos.toByteArray();
                    PublishMQTT.this.publishMessage(context, flowfile, topic, messageContent);
                    processedRecords.getAndIncrement();
                }
            }
            catch (SchemaNotFoundException | MalformedRecordException e) {
                throw new ProcessException("An error happened during creating components for serialization.", e);
            }
        }

        @Override
        public String getFailureTemplateMessage() {
            return PROVENANCE_EVENT_DETAILS_ON_RECORDSET_FAILURE;
        }

        @Override
        public String getRecoverTemplateMessage() {
            return PROVENANCE_EVENT_DETAILS_ON_RECORDSET_RECOVER;
        }

        @Override
        public String getSuccessTemplateMessage() {
            return PROVENANCE_EVENT_DETAILS_ON_RECORDSET_SUCCESS;
        }
    }

    static interface ProcessStrategy {
        public void process(ProcessContext var1, FlowFile var2, InputStream var3, String var4, AtomicInteger var5, Long var6) throws IOException;

        public String getFailureTemplateMessage();

        public String getRecoverTemplateMessage();

        public String getSuccessTemplateMessage();
    }

    class ProcessDemarcatedContentStrategy
    implements ProcessStrategy {
        static final String PROVENANCE_EVENT_DETAILS_ON_DEMARCATED_MESSAGE_FAILURE = "Publish failed after %d successfully published messages.";
        static final String PROVENANCE_EVENT_DETAILS_ON_DEMARCATED_MESSAGE_RECOVER = "Successfully finished publishing previously failed messages. Total message count: %d";
        static final String PROVENANCE_EVENT_DETAILS_ON_DEMARCATED_MESSAGE_SUCCESS = "Successfully published all messages. Total message count: %d";

        ProcessDemarcatedContentStrategy() {
        }

        @Override
        public void process(ProcessContext context, FlowFile flowfile, InputStream in, String topic, AtomicInteger processedRecords, Long previousProcessFailedAt) {
            String demarcator = context.getProperty(MESSAGE_DEMARCATOR).evaluateAttributeExpressions().getValue();
            try (Scanner scanner = new Scanner(in);){
                scanner.useDelimiter(demarcator);
                while (scanner.hasNext()) {
                    String messageContent = scanner.next();
                    if (previousProcessFailedAt != null && (long)processedRecords.get() < previousProcessFailedAt) {
                        processedRecords.getAndIncrement();
                        continue;
                    }
                    PublishMQTT.this.publishMessage(context, flowfile, topic, messageContent.getBytes(StandardCharsets.UTF_8));
                    processedRecords.getAndIncrement();
                }
            }
        }

        @Override
        public String getFailureTemplateMessage() {
            return PROVENANCE_EVENT_DETAILS_ON_DEMARCATED_MESSAGE_FAILURE;
        }

        @Override
        public String getRecoverTemplateMessage() {
            return PROVENANCE_EVENT_DETAILS_ON_DEMARCATED_MESSAGE_RECOVER;
        }

        @Override
        public String getSuccessTemplateMessage() {
            return PROVENANCE_EVENT_DETAILS_ON_DEMARCATED_MESSAGE_SUCCESS;
        }
    }
}

