/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.mongodb.MongoDBClientService;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.serialization.JsonInferenceSchemaRegistryService;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

@Tags(value={"mongo", "mongodb", "lookup", "record"})
@CapabilityDescription(value="Provides a lookup service based around MongoDB. Each key that is specified \nwill be added to a query as-is. For example, if you specify the two keys, \nuser and email, the resulting query will be { \"user\": \"tester\", \"email\": \"tester@test.com\" }.\nThe query is limited to the first result (findOne in the Mongo documentation). If no \"Lookup Value Field\" is specified then the entire MongoDB result document minus the _id field will be returned as a record.")
public class MongoDBLookupService
extends JsonInferenceSchemaRegistryService
implements LookupService<Object> {
    public static final PropertyDescriptor LOCAL_SCHEMA_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(SchemaAccessUtils.SCHEMA_NAME).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor CONTROLLER_SERVICE = new PropertyDescriptor.Builder().name("Client Service").description("A MongoDB controller service to use with this lookup service.").required(true).identifiesControllerService(MongoDBClientService.class).build();
    public static final PropertyDescriptor DATABASE_NAME = new PropertyDescriptor.Builder().name("Mongo Database Name").description("The name of the database to use").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor COLLECTION_NAME = new PropertyDescriptor.Builder().name("Mongo Collection Name").description("The name of the collection to use").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor LOOKUP_VALUE_FIELD = new PropertyDescriptor.Builder().name("Lookup Value Field").description("The field whose value will be returned when the lookup key(s) match a record. If not specified then the entire MongoDB result document minus the _id field will be returned as a record.").addValidator(Validator.VALID).required(false).build();
    public static final PropertyDescriptor PROJECTION = new PropertyDescriptor.Builder().name("Projection").description("Specifies a projection for limiting which fields will be returned.").required(false).addValidator((Validator)JsonValidator.INSTANCE).build();
    private String lookupValueField;
    private volatile Document projection;
    private MongoDBClientService controllerService;
    private String schemaNameProperty;

    public Optional<Object> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        return this.lookup(coordinates, new HashMap<String, String>());
    }

    public Optional<Object> lookup(Map<String, Object> coordinates, Map<String, String> context) throws LookupFailureException {
        Map<String, Object> clean = coordinates.entrySet().stream().filter(e -> !this.schemaNameProperty.equals(String.format("${%s}", e.getKey()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
        Document query = new Document(clean);
        if (coordinates.isEmpty()) {
            throw new LookupFailureException("No keys were configured. Mongo query would return random documents.");
        }
        try {
            Document result = this.findOne(query, this.projection, context);
            if (result == null) {
                return Optional.empty();
            }
            if (!StringUtils.isEmpty((String)this.lookupValueField)) {
                return Optional.ofNullable(result.get((Object)this.lookupValueField));
            }
            RecordSchema schema = this.loadSchema(context, result);
            return Optional.ofNullable(new MapRecord(schema, (Map)result));
        }
        catch (Exception ex) {
            this.getLogger().error("Error during lookup {}", new Object[]{query.toJson(), ex});
            throw new LookupFailureException((Throwable)ex);
        }
    }

    private RecordSchema loadSchema(Map<String, String> context, Document doc) {
        try {
            return this.getSchema(context, (Map)doc, null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        String configuredProjection;
        this.lookupValueField = context.getProperty(LOOKUP_VALUE_FIELD).getValue();
        this.controllerService = (MongoDBClientService)context.getProperty(CONTROLLER_SERVICE).asControllerService(MongoDBClientService.class);
        this.schemaNameProperty = context.getProperty(LOCAL_SCHEMA_NAME).evaluateAttributeExpressions().getValue();
        String string = configuredProjection = context.getProperty(PROJECTION).isSet() ? context.getProperty(PROJECTION).getValue() : null;
        if (!StringUtils.isBlank((String)configuredProjection)) {
            this.projection = Document.parse((String)configuredProjection);
        }
        super.onEnabled(context);
    }

    public Class<?> getValueType() {
        return Record.class;
    }

    public Set<String> getRequiredKeys() {
        return Collections.emptySet();
    }

    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("mongo-lookup-client-service", CONTROLLER_SERVICE.getName());
        config.renameProperty("mongo-db-name", DATABASE_NAME.getName());
        config.renameProperty("mongo-collection-name", COLLECTION_NAME.getName());
        config.renameProperty("mongo-lookup-value-field", LOOKUP_VALUE_FIELD.getName());
        config.renameProperty("mongo-lookup-projection", PROJECTION.getName());
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        AllowableValue[] strategies = new AllowableValue[]{SchemaAccessUtils.SCHEMA_NAME_PROPERTY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY, SchemaAccessUtils.INFER_SCHEMA};
        ArrayList<PropertyDescriptor> _temp = new ArrayList<PropertyDescriptor>();
        _temp.add(new PropertyDescriptor.Builder().fromPropertyDescriptor(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY).allowableValues((DescribedValue[])strategies).defaultValue(this.getDefaultSchemaAccessStrategy().getValue()).build());
        _temp.add(SchemaAccessUtils.SCHEMA_REGISTRY);
        _temp.add(LOCAL_SCHEMA_NAME);
        _temp.add(SchemaAccessUtils.SCHEMA_VERSION);
        _temp.add(SchemaAccessUtils.SCHEMA_BRANCH_NAME);
        _temp.add(SchemaAccessUtils.SCHEMA_TEXT);
        _temp.add(CONTROLLER_SERVICE);
        _temp.add(DATABASE_NAME);
        _temp.add(COLLECTION_NAME);
        _temp.add(LOOKUP_VALUE_FIELD);
        _temp.add(PROJECTION);
        return Collections.unmodifiableList(_temp);
    }

    private Document findOne(Document query, Document projection, Map<String, String> context) {
        String databaseName = this.getProperty(DATABASE_NAME).evaluateAttributeExpressions(context).getValue();
        String collection = this.getProperty(COLLECTION_NAME).evaluateAttributeExpressions(context).getValue();
        MongoCollection col = this.controllerService.getDatabase(databaseName).getCollection(collection);
        MongoCursor it = (projection != null ? col.find((Bson)query).projection((Bson)projection) : col.find((Bson)query)).iterator();
        Document retVal = it.hasNext() ? (Document)it.next() : null;
        it.close();
        return retVal;
    }
}

