/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.mongodb.AbstractMongoProcessor;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.DecoderContext;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;

@Tags(value={"mongodb", "insert", "update", "write", "put", "bulk"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Writes the contents of a FlowFile to MongoDB as bulk-update")
@SystemResourceConsideration(resource=SystemResource.MEMORY)
public class PutMongoBulkOperations
extends AbstractMongoProcessor {
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are written to MongoDB are routed to this relationship").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that cannot be written to MongoDB are routed to this relationship").build();
    static final PropertyDescriptor ORDERED = new PropertyDescriptor.Builder().name("Ordered").expressionLanguageSupported(ExpressionLanguageScope.NONE).description("Ordered execution of bulk-writes and break on error - otherwise arbitrary order and continue on error").required(true).addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    static final PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("Character Set").description("The Character Set in which the data is encoded").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Stream.concat(PutMongoBulkOperations.getCommonPropertyDescriptors().stream(), Stream.of(ORDERED, CHARACTER_SET)).toList();

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (null == flowFile) {
            return;
        }
        Charset charset = Charset.forName(context.getProperty(CHARACTER_SET).getValue());
        WriteConcern writeConcern = this.clientService.getWriteConcern();
        try {
            BsonArray updateItems;
            MongoCollection collection = this.getCollection(context, flowFile).withWriteConcern(writeConcern);
            BsonArrayCodec arrayCodec = new BsonArrayCodec();
            DecoderContext decoderContext = DecoderContext.builder().build();
            try (InputStreamReader reader = new InputStreamReader(session.read(flowFile), charset);){
                updateItems = arrayCodec.decode((BsonReader)new JsonReader((Reader)reader), decoderContext);
            }
            ArrayList<WriteModel<Document>> updateModels = new ArrayList<WriteModel<Document>>();
            for (Object item : updateItems) {
                BsonDocument updateItem = (BsonDocument)item;
                if (updateItem.keySet().size() != 1) {
                    this.getLogger().error("Invalid bulk-update in {}: more than one type given {}", new Object[]{flowFile, String.join((CharSequence)", ", updateItem.keySet())});
                    session.transfer(flowFile, REL_FAILURE);
                    context.yield();
                    return;
                }
                WriteModel<Document> writeModel = this.getWriteModel(updateItem);
                if (null == writeModel) {
                    this.getLogger().error("Invalid bulk-update in {}: invalid update type {}", new Object[]{flowFile, PutMongoBulkOperations.getUpdateType(updateItem)});
                    session.transfer(flowFile, REL_FAILURE);
                    context.yield();
                    return;
                }
                updateModels.add(writeModel);
            }
            collection.bulkWrite(updateModels, new BulkWriteOptions().ordered(context.getProperty(ORDERED).asBoolean().booleanValue()));
            this.getLogger().info("bulk-updated {} into MongoDB", new Object[]{flowFile});
            session.getProvenanceReporter().send(flowFile, this.getURI(context));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to bulk-update {} into MongoDB", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            context.yield();
        }
    }

    private WriteModel<Document> getWriteModel(BsonDocument updateItem) {
        InsertOneModel writeModel;
        String updateType = PutMongoBulkOperations.getUpdateType(updateItem);
        BsonDocument updateSpec = (BsonDocument)updateItem.get((Object)updateType);
        if ("insertOne".equals(updateType)) {
            writeModel = new InsertOneModel((Object)PutMongoBulkOperations.toBsonDocument((BsonDocument)updateSpec.get((Object)"document")));
        } else if ("updateOne".equals(updateType)) {
            UpdateOptions options = this.parseUpdateOptions(updateSpec);
            writeModel = new UpdateOneModel((Bson)((BsonDocument)updateSpec.get((Object)"filter")), (Bson)((BsonDocument)updateSpec.get((Object)"update")), options);
        } else if ("updateMany".equals(updateType)) {
            UpdateOptions options = this.parseUpdateOptions(updateSpec);
            writeModel = new UpdateManyModel((Bson)((BsonDocument)updateSpec.get((Object)"filter")), (Bson)((BsonDocument)updateSpec.get((Object)"update")), options);
        } else if ("replaceOne".equals(updateType)) {
            ReplaceOptions options = this.parseReplaceOptions(updateSpec);
            writeModel = new ReplaceOneModel((Bson)((BsonDocument)updateSpec.get((Object)"filter")), (Object)PutMongoBulkOperations.toBsonDocument((BsonDocument)updateSpec.get((Object)"replacement")), options);
        } else if ("deleteOne".equals(updateType)) {
            DeleteOptions options = this.parseDeleteOptions(updateSpec);
            writeModel = new DeleteOneModel((Bson)((BsonDocument)updateSpec.get((Object)"filter")), options);
        } else if ("deleteMany".equals(updateType)) {
            DeleteOptions options = this.parseDeleteOptions(updateSpec);
            writeModel = new DeleteManyModel((Bson)((BsonDocument)updateSpec.get((Object)"filter")), options);
        } else {
            return null;
        }
        return writeModel;
    }

    private static String getUpdateType(BsonDocument updateItem) {
        return (String)updateItem.keySet().iterator().next();
    }

    private static Document toBsonDocument(BsonDocument doc) {
        if (null == doc) {
            return null;
        }
        return new Document((Map)doc);
    }

    protected UpdateOptions parseUpdateOptions(BsonDocument updateSpec) {
        UpdateOptions options = new UpdateOptions();
        if (updateSpec.containsKey((Object)"upsert")) {
            options.upsert(updateSpec.getBoolean((Object)"upsert").getValue());
        }
        if (updateSpec.containsKey((Object)"arrayFilters")) {
            options.arrayFilters((List)updateSpec.get((Object)"arrayFilters"));
        }
        if (updateSpec.containsKey((Object)"collation")) {
            options.collation(this.parseCollation((BsonDocument)updateSpec.get((Object)"collation")));
        }
        return options;
    }

    protected ReplaceOptions parseReplaceOptions(BsonDocument updateSpec) {
        ReplaceOptions options = new ReplaceOptions();
        if (updateSpec.containsKey((Object)"upsert")) {
            options.upsert(updateSpec.getBoolean((Object)"upsert").getValue());
        }
        if (updateSpec.containsKey((Object)"collation")) {
            options.collation(this.parseCollation((BsonDocument)updateSpec.get((Object)"collation")));
        }
        return options;
    }

    protected DeleteOptions parseDeleteOptions(BsonDocument updateSpec) {
        DeleteOptions options = new DeleteOptions();
        if (updateSpec.containsKey((Object)"collation")) {
            options.collation(this.parseCollation((BsonDocument)updateSpec.get((Object)"collation")));
        }
        return options;
    }

    protected Collation parseCollation(BsonDocument collationSpec) {
        Collation.Builder builder = Collation.builder();
        if (collationSpec.containsKey((Object)"locale")) {
            builder.locale(collationSpec.getString((Object)"locale").getValue());
        }
        if (collationSpec.containsKey((Object)"caseLevel")) {
            builder.caseLevel(Boolean.valueOf(collationSpec.getBoolean((Object)"caseLevel").getValue()));
        }
        if (collationSpec.containsKey((Object)"caseFirst")) {
            builder.collationCaseFirst(CollationCaseFirst.fromString((String)collationSpec.getString((Object)"caseFirst").getValue()));
        }
        if (collationSpec.containsKey((Object)"strength")) {
            builder.collationStrength(CollationStrength.fromInt((int)collationSpec.getInt32((Object)"strength").getValue()));
        }
        if (collationSpec.containsKey((Object)"numericOrdering")) {
            builder.numericOrdering(Boolean.valueOf(collationSpec.getBoolean((Object)"numericOrdering").getValue()));
        }
        if (collationSpec.containsKey((Object)"alternate")) {
            builder.collationAlternate(CollationAlternate.fromString((String)collationSpec.getString((Object)"alternate").getValue()));
        }
        if (collationSpec.containsKey((Object)"maxVariable")) {
            builder.collationMaxVariable(CollationMaxVariable.fromString((String)collationSpec.getString((Object)"maxVariable").getValue()));
        }
        if (collationSpec.containsKey((Object)"normalization")) {
            builder.normalization(Boolean.valueOf(collationSpec.getBoolean((Object)"normalization").getValue()));
        }
        if (collationSpec.containsKey((Object)"backwards")) {
            builder.backwards(Boolean.valueOf(collationSpec.getBoolean((Object)"backwards").getValue()));
        }
        return builder.build();
    }
}

