/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.mongodb;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextProvider;
import org.bson.Document;

public interface MongoDBClientService
extends ControllerService,
VerifiableControllerService {
    public static final String WRITE_CONCERN_ACKNOWLEDGED = "ACKNOWLEDGED";
    public static final String WRITE_CONCERN_UNACKNOWLEDGED = "UNACKNOWLEDGED";
    public static final String WRITE_CONCERN_FSYNCED = "FSYNCED";
    public static final String WRITE_CONCERN_JOURNALED = "JOURNALED";
    public static final String WRITE_CONCERN_REPLICA_ACKNOWLEDGED = "REPLICA_ACKNOWLEDGED";
    public static final String WRITE_CONCERN_MAJORITY = "MAJORITY";
    public static final String WRITE_CONCERN_W1 = "W1";
    public static final String WRITE_CONCERN_W2 = "W2";
    public static final String WRITE_CONCERN_W3 = "W3";
    public static final AllowableValue WRITE_CONCERN_ACKNOWLEDGED_VALUE = new AllowableValue("ACKNOWLEDGED", "ACKNOWLEDGED", "Write operations that use this write concern will wait for acknowledgement, using the default write concern configured on the server");
    public static final AllowableValue WRITE_CONCERN_UNACKNOWLEDGED_VALUE = new AllowableValue("UNACKNOWLEDGED", "UNACKNOWLEDGED", "Write operations that use this write concern will return as soon as the message is written to the socket. Exceptions are raised for network issues, but not server errors");
    public static final AllowableValue WRITE_CONCERN_FSYNCED_VALUE = new AllowableValue("FSYNCED", "FSYNCED", "Deprecated.  Use of \"JOURNALED\" is preferred");
    public static final AllowableValue WRITE_CONCERN_JOURNALED_VALUE = new AllowableValue("JOURNALED", "JOURNALED", "Write operations wait for the server to group commit to the journal file on disk");
    public static final AllowableValue WRITE_CONCERN_REPLICA_ACKNOWLEDGED_VALUE = new AllowableValue("REPLICA_ACKNOWLEDGED", "REPLICA_ACKNOWLEDGED", "Deprecated.  Use of \"W2\" is preferred");
    public static final AllowableValue WRITE_CONCERN_MAJORITY_VALUE = new AllowableValue("MAJORITY", "MAJORITY", "Exceptions are raised for network issues, and server errors; waits on a majority of servers for the write operation");
    public static final AllowableValue WRITE_CONCERN_W1_VALUE = new AllowableValue("W1", "W1", "Write operations that use this write concern will wait for acknowledgement from a single member");
    public static final AllowableValue WRITE_CONCERN_W2_VALUE = new AllowableValue("W2", "W2", "Write operations that use this write concern will wait for acknowledgement from two members");
    public static final AllowableValue WRITE_CONCERN_W3_VALUE = new AllowableValue("W3", "W3", "Write operations that use this write concern will wait for acknowledgement from three members");
    public static final PropertyDescriptor URI = new PropertyDescriptor.Builder().name("Mongo URI").description("MongoURI, typically of the form: mongodb://host1[:port1][,host2[:port2],...]").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.URI_VALIDATOR).build();
    public static final PropertyDescriptor DB_USER = new PropertyDescriptor.Builder().name("Database User").description("Database user name").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor DB_PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password for the database user").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections.").required(false).identifiesControllerService(SSLContextProvider.class).build();
    public static final PropertyDescriptor WRITE_CONCERN = new PropertyDescriptor.Builder().name("Write Concern").description("The write concern to use").required(true).allowableValues(new DescribedValue[]{WRITE_CONCERN_ACKNOWLEDGED_VALUE, WRITE_CONCERN_UNACKNOWLEDGED_VALUE, WRITE_CONCERN_FSYNCED_VALUE, WRITE_CONCERN_JOURNALED_VALUE, WRITE_CONCERN_REPLICA_ACKNOWLEDGED_VALUE, WRITE_CONCERN_MAJORITY_VALUE, WRITE_CONCERN_W1_VALUE, WRITE_CONCERN_W2_VALUE, WRITE_CONCERN_W3_VALUE}).defaultValue(WRITE_CONCERN_ACKNOWLEDGED_VALUE.getValue()).build();

    default public Document convertJson(String query) {
        return Document.parse((String)query);
    }

    public MongoDatabase getDatabase(String var1);

    public String getURI();

    public WriteConcern getWriteConcern();
}

