/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardExpressionLanguageCompiler;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.expression.ExpressionLanguageCompiler;
import org.apache.nifi.parameter.ExpressionLanguageAgnosticParameterParser;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.util.ControllerServiceConfiguration;
import org.apache.nifi.util.MockControllerServiceLookup;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.MockPropertyValue;

public class MockValidationContext
extends MockControllerServiceLookup
implements ValidationContext {
    private final MockProcessContext context;
    private final Map<String, Boolean> expressionLanguageSupported;
    private final StateManager stateManager;
    private final ParameterLookup parameterLookup;
    private volatile boolean validateExpressions = true;

    public MockValidationContext(MockProcessContext processContext) {
        this(processContext, null);
    }

    public MockValidationContext(MockProcessContext processContext, StateManager stateManager) {
        this(processContext, stateManager, ParameterLookup.EMPTY);
    }

    public MockValidationContext(MockProcessContext processContext, StateManager stateManager, ParameterLookup parameterLookup) {
        this.context = processContext;
        this.stateManager = stateManager;
        this.parameterLookup = parameterLookup != null ? parameterLookup : processContext.getParameterLookup();
        Map<PropertyDescriptor, String> properties = processContext.getProperties();
        this.expressionLanguageSupported = new HashMap<String, Boolean>(properties.size());
        for (PropertyDescriptor descriptor : properties.keySet()) {
            this.expressionLanguageSupported.put(descriptor.getName(), descriptor.isExpressionLanguageSupported());
        }
    }

    public void setValidateExpressions(boolean validate) {
        this.validateExpressions = validate;
    }

    @Override
    public ControllerService getControllerService(String identifier) {
        return this.context.getControllerService(identifier);
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new MockPropertyValue(rawValue, this, null, true, this.context.getEnvironmentVariables(), this.parameterLookup);
    }

    public ExpressionLanguageCompiler newExpressionLanguageCompiler() {
        return new StandardExpressionLanguageCompiler(this.parameterLookup);
    }

    public ValidationContext getControllerServiceValidationContext(ControllerService controllerService) {
        MockProcessContext serviceProcessContext = new MockProcessContext(controllerService, this.context, this.stateManager, this.context.getEnvironmentVariables());
        MockValidationContext serviceValidationContext = new MockValidationContext(serviceProcessContext, this.stateManager, this.parameterLookup);
        serviceValidationContext.setValidateExpressions(this.validateExpressions);
        return serviceValidationContext;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        PropertyDescriptor canonicalDescriptor = this.context.getPropertyDescriptor(property.getName());
        if (canonicalDescriptor == null) {
            return null;
        }
        String propertyValue = this.getEffectiveValue(canonicalDescriptor);
        return new MockPropertyValue(propertyValue, this, canonicalDescriptor, true, this.context.getEnvironmentVariables(), this.parameterLookup);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        Map<PropertyDescriptor, String> properties = this.context.getProperties();
        LinkedHashMap<PropertyDescriptor, String> effectiveProperties = new LinkedHashMap<PropertyDescriptor, String>(properties.size());
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            PropertyDescriptor descriptor = entry.getKey();
            String effectiveValue = this.getEffectiveValue(descriptor, entry.getValue());
            effectiveProperties.put(descriptor, effectiveValue);
        }
        return Collections.unmodifiableMap(effectiveProperties);
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String getAnnotationData() {
        return this.context.getAnnotationData();
    }

    @Override
    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.context.getControllerServiceIdentifiers(serviceType);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    @Override
    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.context.isControllerServiceEnabled(serviceIdentifier);
    }

    @Override
    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.context.isControllerServiceEnabled(service);
    }

    @Override
    public String getControllerServiceName(String serviceIdentifier) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(serviceIdentifier);
        return configuration == null ? null : serviceIdentifier;
    }

    public boolean isValidationRequired(ControllerService service) {
        return true;
    }

    @Override
    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.context.isControllerServiceEnabling(serviceIdentifier);
    }

    public boolean isExpressionLanguagePresent(String value) {
        if (value == null) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)value);
        return !elRanges.isEmpty();
    }

    public boolean isExpressionLanguageSupported(String propertyName) {
        Boolean supported = this.expressionLanguageSupported.get(propertyName);
        return Boolean.TRUE.equals(supported);
    }

    public String getProcessGroupIdentifier() {
        return "unit test";
    }

    public Collection<String> getReferencedParameters(String propertyName) {
        PropertyDescriptor descriptor = new PropertyDescriptor.Builder().name(propertyName).build();
        PropertyValue propertyValue = this.context.getPropertyWithoutValidatingExpressions(descriptor);
        String rawPropertyValue = propertyValue == null ? null : propertyValue.getValue();
        boolean elSupported = this.isExpressionLanguageSupported(propertyName);
        ExpressionLanguageAwareParameterParser parser = elSupported ? new ExpressionLanguageAwareParameterParser() : new ExpressionLanguageAgnosticParameterParser();
        List references = parser.parseTokens(rawPropertyValue).toReferenceList();
        return references.stream().map(ParameterReference::getParameterName).collect(Collectors.toList());
    }

    public boolean isParameterDefined(String parameterName) {
        Map<String, String> contextParameters = this.context.getContextParameters();
        return contextParameters.containsKey(parameterName);
    }

    public boolean isParameterSet(String parameterName) {
        Map<String, String> contextParameters = this.context.getContextParameters();
        return contextParameters.containsKey(parameterName) && contextParameters.get(parameterName) != null;
    }

    private String getEffectiveValue(PropertyDescriptor descriptor) {
        String configuredValue = this.context.getProperties().get(descriptor);
        return this.getEffectiveValue(descriptor, configuredValue);
    }

    private String getEffectiveValue(PropertyDescriptor descriptor, String configuredValue) {
        String value;
        String string = value = configuredValue == null ? descriptor.getDefaultValue() : configuredValue;
        if (value == null) {
            return null;
        }
        ExpressionLanguageAwareParameterParser parser = descriptor.isExpressionLanguageSupported() ? new ExpressionLanguageAwareParameterParser() : new ExpressionLanguageAgnosticParameterParser();
        return parser.parseTokens(value).substitute(this.parameterLookup);
    }
}

