/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.util.EmptyControllerServiceLookup;
import org.apache.nifi.util.MockPropertyValue;

public class MockConfigurationContext
implements ConfigurationContext {
    private final Map<PropertyDescriptor, String> properties;
    private final ControllerServiceLookup serviceLookup;
    private final ControllerService service;
    private volatile boolean validateExpressions;
    private Map<String, String> environmentVariables;

    public MockConfigurationContext(Map<PropertyDescriptor, String> properties, ControllerServiceLookup serviceLookup, Map<String, String> environmentVariables) {
        this(null, properties, serviceLookup, environmentVariables);
    }

    public MockConfigurationContext(ControllerService service, Map<PropertyDescriptor, String> properties, ControllerServiceLookup serviceLookup, Map<String, String> environmentVariables) {
        this.service = service;
        this.properties = properties;
        this.serviceLookup = serviceLookup == null ? new EmptyControllerServiceLookup() : serviceLookup;
        this.environmentVariables = environmentVariables;
    }

    public void setValidateExpressions(boolean validate) {
        this.validateExpressions = validate;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        PropertyDescriptor canonicalDescriptor = this.getActualDescriptor(property);
        String value = this.properties.get(property);
        if (value == null) {
            value = canonicalDescriptor.getDefaultValue();
        }
        boolean alreadyEvaluated = !this.validateExpressions;
        return new MockPropertyValue(value, this.serviceLookup, canonicalDescriptor, alreadyEvaluated, this.environmentVariables);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return new HashMap<PropertyDescriptor, String>(this.properties);
    }

    public String getAnnotationData() {
        return null;
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    private PropertyDescriptor getActualDescriptor(PropertyDescriptor property) {
        if (this.service == null) {
            return property;
        }
        PropertyDescriptor resolved = this.service.getPropertyDescriptor(property.getName());
        return resolved == null ? property : resolved;
    }

    public String getSchedulingPeriod() {
        return "0 secs";
    }

    public Long getSchedulingPeriod(TimeUnit timeUnit) {
        return 0L;
    }

    public String getName() {
        return null;
    }
}

