/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.migration.RelationshipConfiguration;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.util.RelationshipMigrationResult;

public class MockRelationshipConfiguration
implements RelationshipConfiguration {
    private final Map<String, Set<String>> relationshipSplits = new HashMap<String, Set<String>>();
    private final Map<String, String> relationshipRenames = new HashMap<String, String>();
    private final Map<String, Relationship> rawRelationships;
    private final Set<Relationship> originalRelationships;

    public MockRelationshipConfiguration(Set<Relationship> relationships) {
        this.originalRelationships = Collections.unmodifiableSet(relationships);
        this.rawRelationships = relationships.stream().collect(Collectors.toMap(Relationship::getName, Function.identity()));
    }

    public RelationshipMigrationResult toRelationshipMigrationResult() {
        return new RelationshipMigrationResult(){

            @Override
            public Map<String, Set<String>> getPreviousRelationships() {
                return Collections.unmodifiableMap(MockRelationshipConfiguration.this.relationshipSplits);
            }

            @Override
            public Map<String, String> getRenamedRelationships() {
                return Collections.unmodifiableMap(MockRelationshipConfiguration.this.relationshipRenames);
            }
        };
    }

    public boolean renameRelationship(String relationshipName, String newName) {
        this.relationshipRenames.put(relationshipName, newName);
        boolean hasRelationship = this.hasRelationship(relationshipName);
        if (!hasRelationship) {
            return false;
        }
        this.rawRelationships.remove(relationshipName);
        this.rawRelationships.put(relationshipName, this.findRelationshipByName(newName));
        return true;
    }

    public boolean splitRelationship(String relationshipName, String newRelationshipName, String ... additionalRelationshipNames) {
        HashSet<String> newRelationships = new HashSet<String>();
        newRelationships.add(newRelationshipName);
        if (additionalRelationshipNames != null) {
            newRelationships.addAll(Arrays.stream(additionalRelationshipNames).toList());
        }
        this.relationshipSplits.put(relationshipName, newRelationships);
        boolean hasRelationship = this.hasRelationship(relationshipName);
        if (!hasRelationship) {
            return false;
        }
        this.rawRelationships.remove(relationshipName);
        newRelationships.forEach(r -> this.rawRelationships.put((String)r, this.findRelationshipByName((String)r)));
        return true;
    }

    public boolean hasRelationship(String relationshipName) {
        return this.rawRelationships.containsKey(relationshipName);
    }

    private Relationship findRelationshipByName(String name) {
        return this.originalRelationships.stream().filter(r -> name.equals(r.getName())).findFirst().orElseThrow();
    }

    public Set<Relationship> getRawRelationships() {
        return Set.copyOf(this.rawRelationships.values());
    }
}

