/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.File;
import java.util.Set;
import java.util.UUID;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.kerberos.KerberosContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.MockProcessContext;

public class MockProcessorInitializationContext
implements ProcessorInitializationContext,
ControllerServiceLookup {
    private final MockComponentLog logger;
    private final String processorId = UUID.randomUUID().toString();
    private final MockProcessContext context;
    private final KerberosContext kerberosContext;

    public MockProcessorInitializationContext(Processor processor, MockProcessContext context) {
        this(processor, context, null, null);
    }

    public MockProcessorInitializationContext(Processor processor, MockProcessContext context, MockComponentLog logger) {
        this(processor, context, logger, null);
    }

    public MockProcessorInitializationContext(Processor processor, MockProcessContext context, MockComponentLog logger, KerberosContext kerberosContext) {
        this.logger = logger == null ? new MockComponentLog(this.processorId, processor) : logger;
        this.context = context;
        this.kerberosContext = kerberosContext;
    }

    public String getIdentifier() {
        return this.processorId;
    }

    public MockComponentLog getLogger() {
        return this.logger;
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.context.getControllerServiceIdentifiers(serviceType);
    }

    public ControllerService getControllerService(String identifier) {
        return this.context.getControllerService(identifier);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public String getControllerServiceName(String serviceIdentifier) {
        return this.context.getControllerServiceName(serviceIdentifier);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.context.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.context.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.context.isControllerServiceEnabling(serviceIdentifier);
    }

    public NodeTypeProvider getNodeTypeProvider() {
        return this.context;
    }

    public String getKerberosServicePrincipal() {
        return this.kerberosContext != null ? this.kerberosContext.getKerberosServicePrincipal() : null;
    }

    public File getKerberosServiceKeytab() {
        return this.kerberosContext != null ? this.kerberosContext.getKerberosServiceKeytab() : null;
    }

    public File getKerberosConfigurationFile() {
        return this.kerberosContext != null ? this.kerberosContext.getKerberosConfigurationFile() : null;
    }
}

