/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDependency;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.ControllerServiceConfiguration;
import org.apache.nifi.util.MockControllerServiceLookup;
import org.apache.nifi.util.MockParameterLookup;
import org.apache.nifi.util.MockPropertyValue;
import org.apache.nifi.util.MockValidationContext;
import org.junit.jupiter.api.Assertions;

public class MockProcessContext
extends MockControllerServiceLookup
implements ProcessContext,
ControllerServiceLookup,
NodeTypeProvider {
    private final ConfigurableComponent component;
    private final String componentName;
    private final Map<PropertyDescriptor, String> properties = new HashMap<PropertyDescriptor, String>();
    private final StateManager stateManager;
    private String annotationData = null;
    private boolean yieldCalled = false;
    private boolean allowExpressionValidation = true;
    private volatile boolean incomingConnection = true;
    private volatile boolean nonLoopConnection = true;
    private volatile InputRequirement inputRequirement = null;
    private int maxConcurrentTasks = 1;
    private volatile Set<Relationship> connections = new HashSet<Relationship>();
    private volatile Set<Relationship> unavailableRelationships = new HashSet<Relationship>();
    private volatile boolean isClustered;
    private volatile boolean isConfiguredForClustering;
    private volatile boolean isPrimaryNode;
    private volatile boolean isConnected = true;
    private final Map<String, String> environmentVariables;
    private final ParameterLookup parameterLookup;

    public MockProcessContext(ConfigurableComponent component) {
        this(component, null, (StateManager)new MockStateManager(component), null);
    }

    public MockProcessContext(ConfigurableComponent component, String componentName) {
        this(component, componentName, (StateManager)new MockStateManager(component), null);
    }

    public MockProcessContext(ConfigurableComponent component, StateManager stateManager) {
        this(component, null, stateManager, null);
    }

    public MockProcessContext(ControllerService component, MockProcessContext context, StateManager stateManager, Map<String, String> environmentVariables) {
        this(component, null, context, stateManager, environmentVariables);
    }

    public MockProcessContext(ControllerService component, String componentName, MockProcessContext context, StateManager stateManager, Map<String, String> environmentVariables) {
        this((ConfigurableComponent)component, componentName, stateManager, environmentVariables);
        try {
            this.annotationData = context.getControllerServiceAnnotationData(component);
            Map<PropertyDescriptor, String> props = context.getControllerServiceProperties(component);
            this.properties.putAll(props);
            super.addControllerServices(context);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public MockProcessContext(ConfigurableComponent component, String componentName, StateManager stateManager, Map<String, String> environmentVariables) {
        this(component, componentName, stateManager, environmentVariables, null);
    }

    public MockProcessContext(ConfigurableComponent component, String componentName, StateManager stateManager, Map<String, String> environmentVariables, Map<String, String> contextParameters) {
        this.component = Objects.requireNonNull(component);
        this.componentName = componentName == null ? "" : componentName;
        this.inputRequirement = component.getClass().getAnnotation(InputRequirement.class);
        this.stateManager = stateManager;
        this.environmentVariables = environmentVariables;
        this.parameterLookup = contextParameters != null ? new MockParameterLookup(contextParameters) : ParameterLookup.EMPTY;
    }

    public PropertyValue getProperty(PropertyDescriptor descriptor) {
        return this.getProperty(descriptor.getName());
    }

    public PropertyValue getPropertyWithoutValidatingExpressions(PropertyDescriptor propertyDescriptor) {
        PropertyDescriptor canonicalDescriptor = this.component.getPropertyDescriptor(propertyDescriptor.getName());
        if (canonicalDescriptor == null) {
            return null;
        }
        String setPropertyValue = this.properties.get(canonicalDescriptor);
        String propValue = setPropertyValue == null ? canonicalDescriptor.getDefaultValue() : setPropertyValue;
        return new MockPropertyValue(propValue, this, canonicalDescriptor, true, this.environmentVariables);
    }

    public PropertyValue getProperty(String propertyName) {
        PropertyDescriptor descriptor = this.component.getPropertyDescriptor(propertyName);
        if (descriptor == null) {
            return null;
        }
        List<ValidatedPropertyDependency> unsatisfiedDependencies = this.determineUnsatisfiedDependencies(descriptor);
        if (!unsatisfiedDependencies.isEmpty()) {
            throw new AssertionError((Object)"Attempted to use property \"%s\" whose dependencies are not satisfied:\n%s\n\n%s".formatted(descriptor.getName(), unsatisfiedDependencies.stream().map(ValidatedPropertyDependency::toString).collect(Collectors.joining("\n")), "Properties whose dependencies are not satisfied are not shown to the user,\ntheir values should be ignored by the implementation if the necessary dependencies are not fulfilled.\nThis precaution is crucial to prevent potentially confusing and unpredictable side effects for the user.\nSee NIFI-14400 (https://issues.apache.org/jira/browse/NIFI-14400) for more background."));
        }
        String setPropertyValue = this.properties.get(descriptor);
        String propValue = setPropertyValue == null ? descriptor.getDefaultValue() : setPropertyValue;
        boolean alreadyEvaluated = !this.allowExpressionValidation;
        return new MockPropertyValue(propValue, this, descriptor, alreadyEvaluated, this.environmentVariables, this.parameterLookup);
    }

    private List<ValidatedPropertyDependency> determineUnsatisfiedDependencies(PropertyDescriptor descriptor) {
        return this.validatedDependencies(descriptor).stream().filter(Predicate.not(ValidatedPropertyDependency::isSatisfied)).toList();
    }

    private List<ValidatedPropertyDependency> validatedDependencies(PropertyDescriptor descriptor) {
        return descriptor.getDependencies().stream().map(dependency -> {
            PropertyDescriptor dependencyDescriptor = this.component.getPropertyDescriptor(dependency.getPropertyName());
            if (dependencyDescriptor == null) {
                return new ValidatedPropertyDependency((PropertyDependency)dependency, null);
            }
            this.component.getPropertyDescriptor(dependency.getPropertyName());
            if (!this.determineUnsatisfiedDependencies(dependencyDescriptor).isEmpty()) {
                return new ValidatedPropertyDependency((PropertyDependency)dependency, null);
            }
            String dependencyPropertyValue = this.properties.getOrDefault(dependencyDescriptor, dependencyDescriptor.getDefaultValue());
            return new ValidatedPropertyDependency((PropertyDependency)dependency, dependencyPropertyValue);
        }).toList();
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new MockPropertyValue(rawValue, (ControllerServiceLookup)this, this.environmentVariables, this.parameterLookup);
    }

    public ValidationResult setProperty(String propertyName, String propertyValue) {
        return this.setProperty(new PropertyDescriptor.Builder().name(propertyName).build(), propertyValue);
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.component.getPropertyDescriptor(propertyName);
    }

    public ValidationResult setProperty(PropertyDescriptor descriptor, String value) {
        Objects.requireNonNull(descriptor, "Cannot set property for null descriptor");
        Objects.requireNonNull(value, "Cannot set property " + descriptor.getName() + " to null value; if the intent is to remove the property, call removeProperty instead");
        PropertyDescriptor fullyPopulatedDescriptor = this.component.getPropertyDescriptor(descriptor.getName());
        ValidationResult result = fullyPopulatedDescriptor.validate(value, (ValidationContext)new MockValidationContext(this, this.stateManager));
        String oldValue = this.properties.put(fullyPopulatedDescriptor, value);
        if (oldValue == null) {
            oldValue = fullyPopulatedDescriptor.getDefaultValue();
        }
        if (!Objects.equals(value, oldValue)) {
            this.component.onPropertyModified(fullyPopulatedDescriptor, oldValue, value);
        }
        return result;
    }

    public boolean removeProperty(PropertyDescriptor descriptor) {
        Objects.requireNonNull(descriptor);
        return this.removeProperty(descriptor.getName());
    }

    public boolean removeProperty(String property) {
        Objects.requireNonNull(property);
        PropertyDescriptor fullyPopulatedDescriptor = this.component.getPropertyDescriptor(property);
        String value = null;
        value = this.properties.remove(fullyPopulatedDescriptor);
        if (value != null) {
            if (!value.equals(fullyPopulatedDescriptor.getDefaultValue())) {
                this.component.onPropertyModified(fullyPopulatedDescriptor, value, null);
            }
            return true;
        }
        return false;
    }

    public void clearProperties() {
        Map<PropertyDescriptor, String> props = this.getProperties();
        for (Map.Entry<PropertyDescriptor, String> e : props.entrySet()) {
            this.removeProperty(e.getKey());
        }
    }

    public void yield() {
        this.yieldCalled = true;
    }

    public boolean isYieldCalled() {
        return this.yieldCalled;
    }

    public void addControllerService(ControllerService controllerService, Map<PropertyDescriptor, String> properties, String annotationData) {
        Objects.requireNonNull(controllerService);
        ControllerServiceConfiguration config = this.addControllerService(controllerService);
        config.setProperties(properties);
        config.setAnnotationData(annotationData);
    }

    public int getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public ExecutionNode getExecutionNode() {
        return ExecutionNode.ALL;
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public Map<PropertyDescriptor, String> getProperties() {
        List supported = this.component.getPropertyDescriptors();
        if (supported == null || supported.isEmpty()) {
            return Collections.unmodifiableMap(this.properties);
        }
        LinkedHashMap<PropertyDescriptor, String> props = new LinkedHashMap<PropertyDescriptor, String>();
        for (PropertyDescriptor descriptor : supported) {
            props.put(descriptor, null);
        }
        props.putAll(this.properties);
        return props;
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public Collection<ValidationResult> validate() {
        MockValidationContext validationContext = new MockValidationContext(this, this.stateManager);
        Collection componentResults = this.component.validate((ValidationContext)validationContext);
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(componentResults);
        Collection<ValidationResult> serviceResults = this.validateReferencedControllerServices(validationContext);
        results.addAll(serviceResults);
        for (Map.Entry<String, ControllerServiceConfiguration> service : this.getControllerServices().entrySet()) {
            if (service.getValue().isEnabled()) continue;
            results.add(new ValidationResult.Builder().explanation("Controller service " + service.getKey() + " for " + this.getName() + " is not enabled").valid(false).build());
        }
        return results;
    }

    protected final Collection<ValidationResult> validateReferencedControllerServices(ValidationContext validationContext) {
        List supportedDescriptors = this.component.getPropertyDescriptors();
        if (supportedDescriptors == null) {
            return Collections.emptyList();
        }
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (PropertyDescriptor descriptor : supportedDescriptors) {
            String controllerServiceId;
            if (descriptor.getControllerServiceDefinition() == null || (controllerServiceId = validationContext.getProperty(descriptor).getValue()) == null) continue;
            ControllerService controllerService = this.getControllerService(controllerServiceId);
            if (controllerService == null) {
                ValidationResult result = new ValidationResult.Builder().valid(false).subject(descriptor.getDisplayName()).input(controllerServiceId).explanation("Invalid Controller Service: " + controllerServiceId + " is not a valid Controller Service Identifier").build();
                validationResults.add(result);
                continue;
            }
            Class requiredServiceClass = descriptor.getControllerServiceDefinition();
            if (!requiredServiceClass.isAssignableFrom(controllerService.getClass())) {
                ValidationResult result = new ValidationResult.Builder().valid(false).subject(descriptor.getDisplayName()).input(controllerServiceId).explanation("Invalid Controller Service: " + controllerServiceId + " does not implement interface " + String.valueOf(requiredServiceClass)).build();
                validationResults.add(result);
                continue;
            }
            boolean enabled = this.isControllerServiceEnabled(controllerServiceId);
            if (enabled) continue;
            validationResults.add(new ValidationResult.Builder().input(controllerServiceId).subject(descriptor.getDisplayName()).explanation("Controller Service with ID " + controllerServiceId + " is not enabled").valid(false).build());
        }
        return validationResults;
    }

    public boolean isValid() {
        for (ValidationResult result : this.validate()) {
            if (result.isValid()) continue;
            return false;
        }
        return true;
    }

    public void assertValid() {
        StringBuilder sb = new StringBuilder();
        int failureCount = 0;
        for (ValidationResult result : this.validate()) {
            if (result.isValid()) continue;
            sb.append(result).append("\n");
            ++failureCount;
        }
        if (failureCount > 0) {
            Assertions.fail((String)("Processor has " + failureCount + " validation failures:\n" + String.valueOf(sb)));
        }
    }

    public void setValidateExpressionUsage(boolean validate) {
        this.allowExpressionValidation = validate;
    }

    Map<PropertyDescriptor, String> getControllerServiceProperties(ControllerService controllerService) {
        return super.getConfiguration(controllerService.getIdentifier()).getProperties();
    }

    String getControllerServiceAnnotationData(ControllerService controllerService) {
        return super.getConfiguration(controllerService.getIdentifier()).getAnnotationData();
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public Set<Relationship> getAllRelationships() {
        if (!(this.component instanceof Processor)) {
            return Collections.emptySet();
        }
        return new HashSet<Relationship>(((Processor)this.component).getRelationships());
    }

    public Set<Relationship> getAvailableRelationships() {
        Set<Relationship> relationships = this.getAllRelationships();
        relationships.removeAll(this.unavailableRelationships);
        return relationships;
    }

    public boolean isAutoTerminated(Relationship relationship) {
        return false;
    }

    public void setUnavailableRelationships(Set<Relationship> relationships) {
        this.unavailableRelationships = Collections.unmodifiableSet(new HashSet<Relationship>(relationships));
    }

    public Set<Relationship> getUnavailableRelationships() {
        return this.unavailableRelationships;
    }

    public boolean hasIncomingConnection() {
        return this.incomingConnection;
    }

    public void setIncomingConnection(boolean hasIncomingConnection) {
        this.incomingConnection = hasIncomingConnection;
    }

    public boolean hasConnection(Relationship relationship) {
        return this.connections.contains(relationship);
    }

    public void setNonLoopConnection(boolean hasNonLoopConnection) {
        this.nonLoopConnection = hasNonLoopConnection;
    }

    public boolean hasNonLoopConnection() {
        return this.nonLoopConnection;
    }

    public void addConnection(Relationship relationship) {
        this.connections.add(relationship);
    }

    public void removeConnection(Relationship relationship) {
        this.connections.remove(relationship);
    }

    public void clearConnections() {
        this.connections = new HashSet<Relationship>();
    }

    public void setConnections(Set<Relationship> connections) {
        this.connections = connections == null ? Collections.emptySet() : Collections.unmodifiableSet(connections);
    }

    public boolean isExpressionLanguagePresent(PropertyDescriptor property) {
        if (property == null || property.getExpressionLanguageScope().equals((Object)ExpressionLanguageScope.NONE)) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)this.getProperty(property).getValue());
        return !elRanges.isEmpty();
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public String getName() {
        return this.componentName;
    }

    public void setMaxConcurrentTasks(int maxConcurrentTasks) {
        this.maxConcurrentTasks = maxConcurrentTasks;
    }

    public boolean isClustered() {
        return this.isClustered;
    }

    public boolean isConfiguredForClustering() {
        return this.isConfiguredForClustering;
    }

    public boolean isPrimary() {
        return this.isPrimaryNode;
    }

    public void setClustered(boolean clustered) {
        this.isClustered = clustered;
    }

    public void setIsConfiguredForClustering(boolean isConfiguredForClustering) {
        this.isConfiguredForClustering = isConfiguredForClustering;
    }

    public void setPrimaryNode(boolean primaryNode) {
        if (!this.isConfiguredForClustering && primaryNode) {
            throw new IllegalArgumentException("Primary node is only available in cluster. Use setIsConfiguredForClustering(true) first.");
        }
        this.isPrimaryNode = primaryNode;
    }

    @Override
    public InputRequirement getInputRequirement() {
        return this.inputRequirement;
    }

    public void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    public boolean isConnectedToCluster() {
        return this.isConnected;
    }

    public int getRetryCount() {
        return 0;
    }

    public boolean isRelationshipRetried(Relationship relationship) {
        return false;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    record ValidatedPropertyDependency(PropertyDependency dependency, String value) {
        public boolean isSatisfied() {
            Set dependentValues = this.dependency.getDependentValues();
            return dependentValues == null ? this.value != null : dependentValues.contains(this.value);
        }

        @Override
        public String toString() {
            String result = this.isSatisfied() ? "satisfied" : "not satisfied";
            Set dependentValues = this.dependency.getDependentValues();
            String reason = dependentValues == null ? "requires any value" : "requires one of the values %s".formatted(dependentValues);
            return "Dependency \"%s\" is %s with value of %s; %s".formatted(this.dependency.getPropertyName(), result, this.value, reason);
        }
    }
}

