/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.util.ControllerServiceConfiguration;

public abstract class MockControllerServiceLookup
implements ControllerServiceLookup {
    private final Map<String, ControllerServiceConfiguration> controllerServiceMap = new ConcurrentHashMap<String, ControllerServiceConfiguration>();

    public Map<String, ControllerServiceConfiguration> getControllerServices() {
        return this.controllerServiceMap;
    }

    public ControllerServiceConfiguration addControllerService(ControllerService service, String identifier) {
        ControllerServiceConfiguration config = new ControllerServiceConfiguration(service);
        this.controllerServiceMap.put(identifier, config);
        return config;
    }

    public ControllerServiceConfiguration addControllerService(ControllerService service) {
        return this.addControllerService(service, service.getIdentifier());
    }

    public void removeControllerService(ControllerService service) {
        ControllerService canonical = this.getControllerService(service.getIdentifier());
        if (canonical == null || canonical != service) {
            throw new IllegalArgumentException("Controller Service " + String.valueOf(service) + " is not known");
        }
        this.controllerServiceMap.remove(service.getIdentifier());
    }

    protected void addControllerServices(MockControllerServiceLookup other) {
        this.controllerServiceMap.putAll(other.controllerServiceMap);
    }

    public ControllerServiceConfiguration getConfiguration(String identifier) {
        return this.controllerServiceMap.get(identifier);
    }

    public ControllerService getControllerService(String identifier) {
        ControllerServiceConfiguration status = this.controllerServiceMap.get(identifier);
        return status == null ? null : status.getService();
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        ControllerServiceConfiguration status = this.controllerServiceMap.get(serviceIdentifier);
        if (status == null) {
            throw new IllegalArgumentException("No ControllerService exists with identifier " + serviceIdentifier);
        }
        return status.isEnabled();
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.isControllerServiceEnabled(service.getIdentifier());
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return false;
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        HashSet<String> ids = new HashSet<String>();
        for (Map.Entry<String, ControllerServiceConfiguration> entry : this.controllerServiceMap.entrySet()) {
            if (!serviceType.isAssignableFrom(entry.getValue().getService().getClass())) continue;
            ids.add(entry.getKey());
        }
        return ids;
    }

    public String getControllerServiceName(String serviceIdentifier) {
        ControllerServiceConfiguration status = this.controllerServiceMap.get(serviceIdentifier);
        return status == null ? null : serviceIdentifier;
    }

    public InputRequirement getInputRequirement() {
        return null;
    }
}

