/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.util.LogMessage;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class CapturingLogger
implements Logger {
    private final Logger logger;
    private final List<LogMessage> traceMessages = Collections.synchronizedList(new ArrayList());
    private final List<LogMessage> debugMessages = Collections.synchronizedList(new ArrayList());
    private final List<LogMessage> infoMessages = Collections.synchronizedList(new ArrayList());
    private final List<LogMessage> warnMessages = Collections.synchronizedList(new ArrayList());
    private final List<LogMessage> errorMessages = Collections.synchronizedList(new ArrayList());

    public CapturingLogger(Logger logger) {
        this.logger = logger;
    }

    public List<LogMessage> getTraceMessages() {
        return Collections.unmodifiableList(this.traceMessages);
    }

    public List<LogMessage> getDebugMessages() {
        return Collections.unmodifiableList(this.debugMessages);
    }

    public List<LogMessage> getInfoMessages() {
        return Collections.unmodifiableList(this.infoMessages);
    }

    public List<LogMessage> getWarnMessages() {
        return Collections.unmodifiableList(this.warnMessages);
    }

    public List<LogMessage> getErrorMessages() {
        return Collections.unmodifiableList(this.errorMessages);
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String msg) {
        this.traceMessages.add(new LogMessage(null, msg, null, new Object[0]));
        this.logger.trace(msg);
    }

    public void trace(String format, Object arg) {
        this.traceMessages.add(new LogMessage(null, format, null, arg));
        this.logger.trace(format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.traceMessages.add(new LogMessage(null, format, null, arg1, arg2));
        this.logger.trace(format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.traceMessages.add(new LogMessage(null, format, null, arguments));
        this.logger.trace(format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.traceMessages.add(new LogMessage(null, msg, t, new Object[0]));
        this.logger.trace(msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.traceMessages.add(new LogMessage(marker, msg, null, new Object[0]));
        this.logger.trace(marker, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.traceMessages.add(new LogMessage(marker, format, null, arg));
        this.logger.trace(marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.traceMessages.add(new LogMessage(marker, format, null, arg1, arg2));
        this.logger.trace(marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        this.traceMessages.add(new LogMessage(marker, format, null, arguments));
        this.logger.trace(marker, format, arguments);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.traceMessages.add(new LogMessage(marker, msg, t, new Object[0]));
        this.logger.trace(marker, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.debugMessages.add(new LogMessage(null, msg, null, new Object[0]));
        this.logger.debug(msg);
    }

    public void debug(String format, Object arg) {
        this.debugMessages.add(new LogMessage(null, format, null, arg));
        this.logger.debug(format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debugMessages.add(new LogMessage(null, format, null, arg1, arg2));
        this.logger.debug(format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.debugMessages.add(new LogMessage(null, format, null, arguments));
        this.logger.debug(format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.debugMessages.add(new LogMessage(null, msg, t, new Object[0]));
        this.logger.debug(msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.debugMessages.add(new LogMessage(marker, msg, null, new Object[0]));
        this.logger.debug(marker, msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debugMessages.add(new LogMessage(marker, format, null, arg));
        this.logger.debug(marker, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debugMessages.add(new LogMessage(marker, format, null, arg1, arg2));
        this.logger.debug(marker, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.debugMessages.add(new LogMessage(marker, format, null, arguments));
        this.logger.debug(marker, format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debugMessages.add(new LogMessage(marker, msg, t, new Object[0]));
        this.logger.debug(marker, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        this.info(msg, (Object)null);
    }

    public void info(String format, Object arg) {
        this.info(format, arg, (Object)null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(format, new Object[]{arg1, arg2});
    }

    public void info(String format, Object ... arguments) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage();
        this.infoMessages.add(new LogMessage(null, message, null, arguments));
        this.logger.info(format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.infoMessages.add(new LogMessage(null, msg, t, new Object[0]));
        this.logger.info(msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.infoMessages.add(new LogMessage(marker, msg, null, new Object[0]));
        this.logger.info(marker, msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.infoMessages.add(new LogMessage(marker, format, null, arg));
        this.logger.info(marker, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.infoMessages.add(new LogMessage(marker, format, null, arg1, arg2));
        this.logger.info(marker, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.infoMessages.add(new LogMessage(marker, format, null, arguments));
        this.logger.info(marker, format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.infoMessages.add(new LogMessage(marker, msg, t, new Object[0]));
        this.logger.debug(marker, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String msg) {
        this.warn(msg, (Object)null);
    }

    public void warn(String format, Object arg) {
        this.warn(format, arg, (Object)null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(format, new Object[]{arg1, arg2});
    }

    public void warn(String format, Object ... arguments) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage();
        this.warnMessages.add(new LogMessage(null, message, null, arguments));
        this.logger.warn(format, arguments);
    }

    public void warn(String msg, Throwable t) {
        this.warnMessages.add(new LogMessage(null, msg, t, new Object[0]));
        this.logger.warn(msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.warnMessages.add(new LogMessage(marker, msg, null, new Object[0]));
        this.logger.warn(marker, msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warnMessages.add(new LogMessage(marker, format, null, arg));
        this.logger.warn(marker, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warnMessages.add(new LogMessage(marker, format, null, arg1, arg2));
        this.logger.warn(marker, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.warnMessages.add(new LogMessage(marker, format, null, arguments));
        this.logger.warn(marker, format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warnMessages.add(new LogMessage(marker, msg, t, new Object[0]));
        this.logger.warn(marker, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String msg) {
        this.errorMessages.add(new LogMessage(null, msg, null, new Object[0]));
        this.logger.error(msg);
    }

    public void error(String format, Object arg) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])new Object[]{arg}).getMessage();
        this.errorMessages.add(new LogMessage(null, message, null, arg));
        this.logger.error(format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])new Object[]{arg1, arg2}).getMessage();
        this.errorMessages.add(new LogMessage(null, message, null, arg1, arg2));
        this.logger.error(format, arg1, arg2);
    }

    public void error(String format, Object arg1, Throwable t) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])new Object[]{arg1}).getMessage();
        this.errorMessages.add(new LogMessage(null, message, t, arg1));
        this.logger.error(format, arg1, (Object)t);
    }

    public void error(String format, Object ... arguments) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage();
        this.errorMessages.add(new LogMessage(null, message, null, arguments));
        this.logger.error(format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.errorMessages.add(new LogMessage(null, msg, t, new Object[0]));
        this.logger.error(msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.errorMessages.add(new LogMessage(marker, msg, null, new Object[0]));
        this.logger.error(marker, msg);
    }

    public void error(Marker marker, String format, Object arg) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])new Object[]{arg}).getMessage();
        this.errorMessages.add(new LogMessage(marker, message, null, arg));
        this.logger.error(marker, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])new Object[]{arg1, arg2}).getMessage();
        this.errorMessages.add(new LogMessage(marker, message, null, arg1, arg2));
        this.logger.error(marker, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage();
        this.errorMessages.add(new LogMessage(marker, message, null, arguments));
        this.logger.error(marker, format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.errorMessages.add(new LogMessage(marker, msg, t, new Object[0]));
        this.logger.error(marker, msg, t);
    }
}

