/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.components.state.StateMap;

public class MockStateMap
implements StateMap {
    private final Map<String, String> stateValues;
    private final String version;

    public MockStateMap(Map<String, String> stateValues, long version) {
        this.stateValues = stateValues == null ? Collections.emptyMap() : new HashMap<String, String>(stateValues);
        this.version = Long.toString(version);
    }

    public Optional<String> getStateVersion() {
        return this.version.equals("-1") ? Optional.empty() : Optional.of(this.version);
    }

    public String get(String key) {
        return this.stateValues.get(key);
    }

    public Map<String, String> toMap() {
        return Collections.unmodifiableMap(this.stateValues);
    }
}

